/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

public abstract class ResourceHelper {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final Pattern LIBRARY_VERSION_PATTERN = Pattern.compile("^(\\d+)(_\\d+)+");
    private static final Pattern RESOURCE_VERSION_PATTERN = Pattern.compile("^((?:\\d+)(?:_\\d+)+)[\\.]?(\\w+)?");
    private static final String COMPRESSED_CONTENT_FILENAME = "compressed-content";
    private static final String[] EL_CONTENT_TYPES = new String[]{"text/css"};

    public abstract String getBaseResourcePath();

    public abstract String getBaseContractsPath();

    protected String getBasePath(String contract) {
        if (contract == null) {
            return this.getBaseResourcePath();
        }
        return this.getBaseContractsPath() + '/' + contract;
    }

    public InputStream getInputStream(ResourceInfo toStream, FacesContext ctx) throws IOException {
        ClientResourceInfo resourceWithoutLocalePrefix;
        ClientResourceInfo resource;
        InputStream in = null;
        if (toStream instanceof ClientResourceInfo && null == (in = this.getInputStreamFromClientInfo(resource = (ClientResourceInfo)toStream, ctx)) && null != (in = this.getInputStreamFromClientInfo(resourceWithoutLocalePrefix = new ClientResourceInfo(resource, false), ctx))) {
            resource.copy(resourceWithoutLocalePrefix);
        }
        return in;
    }

    private InputStream getInputStreamFromClientInfo(ClientResourceInfo resource, FacesContext ctx) throws IOException {
        InputStream in;
        block47: {
            in = null;
            if (resource.isCompressable() && this.clientAcceptsCompression(ctx)) {
                if (!resource.supportsEL()) {
                    try {
                        String path = resource.getCompressedPath();
                        in = new BufferedInputStream(new FileInputStream(path + File.separatorChar + COMPRESSED_CONTENT_FILENAME));
                    }
                    catch (IOException ioe) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
                        }
                        in = null;
                    }
                } else {
                    byte[] buf = new byte[512];
                    try (BufferedInputStream temp = new BufferedInputStream(new ELEvaluatingInputStream(ctx, resource, this.getNonCompressedInputStream(resource, ctx)));
                         ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                         GZIPOutputStream out = new GZIPOutputStream(baos);){
                        int read = ((InputStream)temp).read(buf);
                        while (read != -1) {
                            ((OutputStream)out).write(buf, 0, read);
                            read = ((InputStream)temp).read(buf);
                        }
                        in = new BufferedInputStream(new ByteArrayInputStream(baos.toByteArray()));
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block47;
                        LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
                    }
                }
            }
        }
        if (in == null) {
            if (resource.supportsEL()) {
                return new BufferedInputStream(new ELEvaluatingInputStream(ctx, resource, this.getNonCompressedInputStream(resource, ctx)));
            }
            in = this.getNonCompressedInputStream(resource, ctx);
        }
        return in;
    }

    public abstract URL getURL(ResourceInfo var1, FacesContext var2);

    public abstract LibraryInfo findLibrary(String var1, String var2, String var3, FacesContext var4);

    public abstract ResourceInfo findResource(LibraryInfo var1, String var2, String var3, boolean var4, FacesContext var5);

    public long getLastModified(ResourceInfo resource, FacesContext ctx) {
        URL url = this.getURL(resource, ctx);
        if (url == null) {
            return 0L;
        }
        return Util.getLastModified(url);
    }

    protected abstract InputStream getNonCompressedInputStream(ResourceInfo var1, FacesContext var2) throws IOException;

    protected VersionInfo getVersion(Collection<String> resourcePaths, boolean isResource) {
        ArrayList<VersionInfo> versionedPaths = new ArrayList<VersionInfo>(resourcePaths.size());
        for (String p : resourcePaths) {
            VersionInfo vp = this.getVersion(p, isResource);
            if (vp == null) continue;
            versionedPaths.add(vp);
        }
        VersionInfo version = null;
        if (!versionedPaths.isEmpty()) {
            Collections.sort(versionedPaths);
            version = (VersionInfo)versionedPaths.get(versionedPaths.size() - 1);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compressContent(ClientResourceInfo info) throws IOException {
        InputStream source = null;
        OutputStream dest = null;
        try {
            int totalRead;
            ByteArrayOutputStream baos;
            block22: {
                URL url = info.getHelper().getURL(info, FacesContext.getCurrentInstance());
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                source = conn.getInputStream();
                byte[] buf = new byte[512];
                baos = new ByteArrayOutputStream();
                dest = new GZIPOutputStream(baos);
                totalRead = 0;
                int len = source.read(buf);
                while (len != -1) {
                    dest.write(buf, 0, len);
                    totalRead += len;
                    len = source.read(buf);
                }
                dest.flush();
                try {
                    dest.close();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block22;
                    LOGGER.log(Level.FINEST, "Closing stream", ioe);
                }
            }
            if (baos.size() < totalRead) {
                String outputFile = info.getCompressedPath() + File.separatorChar + COMPRESSED_CONTENT_FILENAME;
                dest = new FileOutputStream(outputFile);
                dest.write(baos.toByteArray());
                dest.flush();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block24: {
                block23: {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (IOException ioe) {
                            if (!LOGGER.isLoggable(Level.FINEST)) break block23;
                            LOGGER.log(Level.FINEST, "Closing stream", ioe);
                        }
                    }
                }
                if (dest != null) {
                    try {
                        dest.close();
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block24;
                        LOGGER.log(Level.FINEST, "Closing stream", ioe);
                    }
                }
            }
        }
    }

    protected boolean clientAcceptsCompression(FacesContext ctx) {
        ExternalContext extCtx = ctx.getExternalContext();
        Object response = extCtx.getResponse();
        if (response instanceof HttpServletResponse) {
            String[] values = extCtx.getRequestHeaderValuesMap().get("accept-encoding");
            boolean gzipFound = false;
            for (String value : values) {
                if (value.contains("gzip;q=0")) {
                    return false;
                }
                if (value.contains("gzip")) {
                    gzipFound = true;
                    break;
                }
                if (!value.contains("*") || value.contains("*;q=0,") || value.endsWith("*;q=0")) continue;
                gzipFound = true;
            }
            if (gzipFound) {
                ((HttpServletResponse)response).setHeader("Content-Encoding", "gzip");
                return true;
            }
        }
        return false;
    }

    protected ClientResourceInfo handleCompression(ClientResourceInfo resource) {
        try {
            if (!resource.supportsEL() && !this.compressContent(resource)) {
                resource = this.rebuildAsNonCompressed(resource);
            }
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
            }
            resource = this.rebuildAsNonCompressed(resource);
        }
        return resource;
    }

    protected boolean resourceSupportsEL(String resourceName, String libraryName, FacesContext ctx) {
        ExternalContext extContext = ctx.getExternalContext();
        String contentType = extContext.getMimeType(resourceName);
        boolean result = contentType != null && Arrays.binarySearch(EL_CONTENT_TYPES, contentType) >= 0 || null != resourceName && null != libraryName && "javax.faces".equals(libraryName) && "jsf.js".equals(resourceName);
        return result;
    }

    protected String trimLeadingSlash(String s) {
        if (s.charAt(0) == '/') {
            return s.substring(1);
        }
        return s;
    }

    private ClientResourceInfo rebuildAsNonCompressed(ClientResourceInfo resource) {
        LibraryInfo library = resource.getLibraryInfo();
        ClientResourceInfo ret = library != null ? new ClientResourceInfo(resource.library, resource.contract, resource.name, resource.version, false, resource.supportsEL, resource.isDevStage, resource.cacheTimestamp) : new ClientResourceInfo(resource.contract, resource.name, resource.version, resource.localePrefix, this, false, resource.supportsEL, resource.isDevStage, resource.cacheTimestamp);
        return ret;
    }

    private VersionInfo getVersion(String pathElement, boolean isResource) {
        Map<String, Object> appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        String[] pathElements = Util.split(appMap, pathElement, "/");
        String path = pathElements[pathElements.length - 1];
        String extension = null;
        if (isResource) {
            Matcher m = RESOURCE_VERSION_PATTERN.matcher(path);
            return m.matches() ? new VersionInfo(m.group(1), m.group(2)) : null;
        }
        return LIBRARY_VERSION_PATTERN.matcher(path).matches() ? new VersionInfo(path, extension) : null;
    }

    protected List<String> getLocalizedPaths(String path, FacesContext ctx) {
        Locale loc;
        Locale locale = loc = ctx != null && ctx.getViewRoot() != null ? ctx.getViewRoot().getLocale() : null;
        if (!path.endsWith(".properties") || loc == null) {
            return Collections.singletonList(path);
        }
        ArrayList<String> list = new ArrayList<String>();
        String base = path.substring(0, path.lastIndexOf(".properties"));
        if (!loc.getVariant().isEmpty()) {
            list.add(String.format("%s_%s_%s_%s.properties", base, loc.getLanguage(), loc.getCountry(), loc.getVariant()));
        }
        if (!loc.getCountry().isEmpty()) {
            list.add(String.format("%s_%s_%s.properties", base, loc.getLanguage(), loc.getCountry()));
        }
        if (!loc.getLanguage().isEmpty()) {
            list.add(String.format("%s_%s.properties", base, loc.getLanguage()));
        }
        list.add(path);
        return list;
    }

    static {
        Arrays.sort(EL_CONTENT_TYPES);
    }

    private static final class ELEvaluatingInputStream
    extends InputStream {
        private List<Integer> buf = new ArrayList<Integer>(1024);
        private boolean failedExpressionTest = false;
        private boolean writingExpression = false;
        private InputStream inner;
        private ClientResourceInfo info;
        private FacesContext ctx;
        private boolean expressionEvaluated;
        private boolean endOfStreamReached;
        private int nextRead = -1;

        public ELEvaluatingInputStream(FacesContext ctx, ClientResourceInfo info, InputStream inner) {
            this.inner = inner;
            this.info = info;
            this.ctx = ctx;
        }

        @Override
        public int read() throws IOException {
            int i;
            if (null == this.inner) {
                return -1;
            }
            if (this.failedExpressionTest) {
                i = this.nextRead;
                this.nextRead = -1;
                this.failedExpressionTest = false;
            } else if (this.writingExpression) {
                if (0 < this.buf.size()) {
                    i = this.buf.remove(0);
                } else {
                    this.writingExpression = false;
                    i = this.inner.read();
                }
            } else {
                i = this.inner.read();
                char c = (char)i;
                if (c == '#') {
                    i = this.inner.read();
                    c = (char)i;
                    if (c == '{') {
                        this.readExpressionIntoBufferAndEvaluateIntoBuffer();
                        this.writingExpression = true;
                        i = this.read();
                    } else {
                        i = 35;
                        this.nextRead = c;
                        this.failedExpressionTest = true;
                    }
                }
            }
            if (i == -1) {
                this.endOfStreamReached = true;
            }
            return i;
        }

        private void readExpressionIntoBufferAndEvaluateIntoBuffer() throws IOException {
            int i;
            char c;
            do {
                if ((c = (char)(i = this.inner.read())) == '}') {
                    this.evaluateExpressionIntoBuffer();
                    continue;
                }
                this.buf.add(i);
            } while (c != '}' && i != -1);
        }

        private void evaluateExpressionIntoBuffer() {
            char[] chars = new char[this.buf.size()];
            int len = this.buf.size();
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)this.buf.get(i).intValue();
            }
            String expressionBody = new String(chars);
            int colon = expressionBody.indexOf(":");
            if (-1 != colon) {
                if (!this.isPropertyValid(expressionBody)) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_COLON_ERROR", expressionBody);
                    throw new ELException(message);
                }
                Map<String, Object> appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
                String[] parts = Util.split(appMap, expressionBody, ":");
                if (null == parts[0] || null == parts[1]) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_NO_LIBRARY_NAME_ERROR", expressionBody);
                    throw new ELException(message);
                }
                try {
                    int mark = parts[0].indexOf("[") + 2;
                    char quoteMark = parts[0].charAt(mark - 1);
                    parts[0] = parts[0].substring(mark, colon);
                    if (parts[0].equals("this")) {
                        LibraryInfo libInfo = this.info.getLibraryInfo();
                        if (null != libInfo) {
                            parts[0] = libInfo.getName();
                        } else if (null != this.info.getContract()) {
                            parts[0] = this.info.getContract();
                        } else {
                            throw new NullPointerException("Resource expression is not a library or resource library contract");
                        }
                        mark = parts[1].indexOf("]") - 1;
                        parts[1] = parts[1].substring(0, mark);
                        expressionBody = "resource[" + quoteMark + parts[0] + ":" + parts[1] + quoteMark + "]";
                    }
                }
                catch (Exception e) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.RESOURCE_INVALID_FORMAT_ERROR", expressionBody);
                    throw new ELException(message);
                }
            }
            ELContext elContext = this.ctx.getELContext();
            this.expressionEvaluated = true;
            ValueExpression ve = this.ctx.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + expressionBody + "}", String.class);
            Object value = ve.getValue(elContext);
            String expressionResult = value != null ? value.toString() : "";
            this.buf.clear();
            int len2 = expressionResult.length();
            for (int i = 0; i < len2; ++i) {
                this.buf.add(Integer.valueOf(expressionResult.charAt(i)));
            }
        }

        @Override
        public void close() throws IOException {
            if (this.endOfStreamReached && !this.expressionEvaluated) {
                this.info.disableEL();
            }
            this.inner.close();
            super.close();
        }

        private boolean isPropertyValid(String property) {
            int idx = property.indexOf(58);
            return property.indexOf(58, idx + 1) == -1;
        }
    }
}

