/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.component;

import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.Location;
import java.util.Stack;

public class CompositeComponentStackManager {
    private static final String MANAGER_KEY = CompositeComponentStackManager.class.getName();
    private StackHandler treeCreation = new TreeCreationStackHandler();
    private StackHandler runtime = new RuntimeStackHandler();

    private CompositeComponentStackManager() {
    }

    public static CompositeComponentStackManager getManager(FacesContext ctx) {
        CompositeComponentStackManager manager = (CompositeComponentStackManager)ctx.getAttributes().get(MANAGER_KEY);
        if (manager == null) {
            manager = new CompositeComponentStackManager();
            ctx.getAttributes().put(MANAGER_KEY, manager);
        }
        return manager;
    }

    public boolean push(UIComponent compositeComponent) {
        return this.getStackHandler(StackType.Evaluation).push(compositeComponent);
    }

    public boolean push(UIComponent compositeComponent, StackType stackType) {
        return this.getStackHandler(stackType).push(compositeComponent);
    }

    public boolean push() {
        return this.getStackHandler(StackType.Evaluation).push();
    }

    public boolean push(StackType stackType) {
        return this.getStackHandler(stackType).push();
    }

    public void pop(StackType stackType) {
        this.getStackHandler(stackType).pop();
    }

    public void pop() {
        this.getStackHandler(StackType.Evaluation).pop();
    }

    public UIComponent peek() {
        return this.getStackHandler(StackType.Evaluation).peek();
    }

    public UIComponent peek(StackType stackType) {
        return this.getStackHandler(stackType).peek();
    }

    public UIComponent getParentCompositeComponent(StackType stackType, FacesContext ctx, UIComponent forComponent) {
        return this.getStackHandler(stackType).getParentCompositeComponent(ctx, forComponent);
    }

    public UIComponent findCompositeComponentUsingLocation(FacesContext ctx, Location location) {
        StackHandler sh = this.getStackHandler(StackType.TreeCreation);
        Stack<UIComponent> s = sh.getStack(false);
        if (s != null) {
            String path = location.getPath();
            for (int i = s.size(); i > 0; --i) {
                UIComponent cc = (UIComponent)s.get(i - 1);
                Resource r = (Resource)cc.getAttributes().get("jakarta.faces.application.Resource.ComponentResource");
                if (!path.endsWith('/' + r.getResourceName()) || !path.contains(r.getLibraryName())) continue;
                return cc;
            }
        } else {
            String path = location.getPath();
            UIComponent cc = UIComponent.getCurrentCompositeComponent(ctx);
            while (cc != null) {
                Resource r = (Resource)cc.getAttributes().get("jakarta.faces.application.Resource.ComponentResource");
                if (path.endsWith('/' + r.getResourceName()) && path.contains(r.getLibraryName())) {
                    return cc;
                }
                cc = UIComponent.getCompositeComponentParent(cc);
            }
        }
        return UIComponent.getCurrentCompositeComponent(ctx);
    }

    private StackHandler getStackHandler(StackType type) {
        StackHandler handler = null;
        switch (type) {
            case TreeCreation: {
                handler = this.treeCreation;
                break;
            }
            case Evaluation: {
                handler = this.runtime;
            }
        }
        return handler;
    }

    private final class TreeCreationStackHandler
    extends BaseStackHandler {
        private TreeCreationStackHandler() {
        }

        @Override
        public void pop() {
            Stack<UIComponent> s = this.getStack(false);
            if (s != null && !this.stack.isEmpty()) {
                this.stack.pop();
                if (this.stack.isEmpty()) {
                    this.delete();
                }
            }
        }

        @Override
        public boolean push() {
            return false;
        }

        @Override
        public boolean push(UIComponent compositeComponent) {
            if (compositeComponent != null) {
                assert (UIComponent.isCompositeComponent(compositeComponent));
                Stack<UIComponent> s = this.getStack(true);
                s.push(compositeComponent);
                return true;
            }
            return false;
        }

        @Override
        public UIComponent getParentCompositeComponent(FacesContext ctx, UIComponent forComponent) {
            Stack<UIComponent> s = this.getStack(false);
            if (s == null) {
                return null;
            }
            int idx = s.indexOf(forComponent);
            if (idx == 0) {
                return null;
            }
            return (UIComponent)s.get(idx - 1);
        }
    }

    private final class RuntimeStackHandler
    extends BaseStackHandler {
        private RuntimeStackHandler() {
        }

        @Override
        public void delete() {
            Stack<UIComponent> s = this.getStack(false);
            if (s != null) {
                s.clear();
            }
        }

        @Override
        public void pop() {
            Stack<UIComponent> s = this.getStack(false);
            if (s != null && !s.isEmpty()) {
                s.pop();
            }
        }

        @Override
        public boolean push() {
            return this.push(null);
        }

        @Override
        public boolean push(UIComponent compositeComponent) {
            UIComponent ccp;
            Stack<UIComponent> tstack = CompositeComponentStackManager.this.treeCreation.getStack(false);
            Stack<UIComponent> stack = this.getStack(false);
            if (tstack != null) {
                ccp = compositeComponent;
            } else {
                stack = this.getStack(false);
                ccp = compositeComponent == null ? (stack != null && !stack.isEmpty() ? this.getCompositeParent(stack.peek()) : this.getCompositeParent(UIComponent.getCurrentCompositeComponent(FacesContext.getCurrentInstance()))) : compositeComponent;
            }
            if (ccp != null) {
                if (stack == null) {
                    stack = this.getStack(true);
                }
                stack.push(ccp);
                return true;
            }
            return false;
        }

        @Override
        public UIComponent getParentCompositeComponent(FacesContext ctx, UIComponent forComponent) {
            return this.getCompositeParent(forComponent);
        }

        private UIComponent getCompositeParent(UIComponent comp) {
            return UIComponent.getCompositeComponentParent(comp);
        }
    }

    private abstract class BaseStackHandler
    implements StackHandler {
        protected Stack<UIComponent> stack;

        private BaseStackHandler() {
        }

        @Override
        public void delete() {
            this.stack = null;
        }

        @Override
        public Stack<UIComponent> getStack(boolean create) {
            if (this.stack == null && create) {
                this.stack = new Stack();
            }
            return this.stack;
        }

        @Override
        public UIComponent peek() {
            if (this.stack != null && !this.stack.isEmpty()) {
                return this.stack.peek();
            }
            return null;
        }
    }

    private static interface StackHandler {
        public boolean push(UIComponent var1);

        public boolean push();

        public void pop();

        public UIComponent peek();

        public UIComponent getParentCompositeComponent(FacesContext var1, UIComponent var2);

        public void delete();

        public Stack<UIComponent> getStack(boolean var1);
    }

    public static enum StackType {
        TreeCreation,
        Evaluation;

    }
}

