/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;

public class ImportHandler {
    private Map<String, String> map = new HashMap<String, String>();
    private List<String> packages = new ArrayList<String>();

    public ImportHandler() {
        this.importPackage("java.lang");
    }

    public void importClass(String name) throws ELException {
        int i = name.indexOf(46);
        if (i <= 0) {
            throw new ELException("The name " + name + " is not a full class name");
        }
        String className = name.substring(i + 1);
        this.map.put(className, name);
    }

    public void importPackage(String packageName) {
        this.packages.add(packageName);
    }

    public Class<?> resolve(String name) {
        String className = this.map.get(name);
        if (className != null) {
            return this.getClassFor(className);
        }
        for (String packageName : this.packages) {
            String fullClassName = packageName + "." + name;
            Class<?> c = this.getClassFor(fullClassName);
            if (c == null) continue;
            this.map.put(name, fullClassName);
            return c;
        }
        return null;
    }

    private Class<?> getClassFor(String className) {
        Class<?> c = null;
        try {
            c = Class.forName(className, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return c;
    }
}

