/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.util;

import com.sun.el.lang.ELSupport;
import com.sun.el.util.MessageFactory;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

public class ReflectionUtil {
    protected static final String[] EMPTY_STRING = new String[0];
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class forName(String name) throws ClassNotFoundException {
        if (null == name || "".equals(name)) {
            return null;
        }
        Class<?> c = ReflectionUtil.forNamePrimitive(name);
        if (c == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c = Class.forName(nc, true, Thread.currentThread().getContextClassLoader());
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
        }
        return c;
    }

    protected static Class forNamePrimitive(String name) {
        int p;
        if (name.length() <= 8 && (p = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p];
        }
        return null;
    }

    public static Class[] toTypeArray(String[] s) throws ClassNotFoundException {
        if (s == null) {
            return null;
        }
        Class[] c = new Class[s.length];
        for (int i = 0; i < s.length; ++i) {
            c[i] = ReflectionUtil.forName(s[i]);
        }
        return c;
    }

    public static String[] toTypeNameArray(Class[] c) {
        if (c == null) {
            return null;
        }
        String[] s = new String[c.length];
        for (int i = 0; i < c.length; ++i) {
            s[i] = c[i].getName();
        }
        return s;
    }

    public static PropertyDescriptor getPropertyDescriptor(Object base, Object property) throws ELException, PropertyNotFoundException {
        String name = ELSupport.coerceToString(property);
        Object p = null;
        try {
            PropertyDescriptor[] desc = Introspector.getBeanInfo(base.getClass()).getPropertyDescriptors();
            for (int i = 0; i < desc.length; ++i) {
                if (!desc[i].getName().equals(name)) continue;
                return desc[i];
            }
        }
        catch (IntrospectionException ie) {
            throw new ELException(ie);
        }
        throw new PropertyNotFoundException(MessageFactory.get("error.property.notfound", base, name));
    }

    public static Object invokeMethod(ELContext context, Method m, Object base, Object[] params) {
        Object[] parameters = ReflectionUtil.buildParameters(context, m.getParameterTypes(), m.isVarArgs(), params);
        try {
            return m.invoke(base, parameters);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(iae);
        }
        catch (IllegalArgumentException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?>[] paramTypes, Object[] paramValues) {
        Method[] methods;
        List<Wrapper> wrappers;
        Wrapper result;
        if (clazz == null || methodName == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", clazz, methodName, ReflectionUtil.paramString(paramTypes)));
        }
        if (paramTypes == null) {
            paramTypes = ReflectionUtil.getTypesFromValues(paramValues);
        }
        if ((result = ReflectionUtil.findWrapper(clazz, wrappers = Wrapper.wrap(methods = clazz.getMethods(), methodName), methodName, paramTypes, paramValues)) == null) {
            return null;
        }
        return ReflectionUtil.getMethod(clazz, (Method)result.unWrap());
    }

    private static Wrapper findWrapper(Class<?> clazz, List<Wrapper> wrappers, String name, Class<?>[] paramTypes, Object[] paramValues) {
        ArrayList<Wrapper> assignableCandidates = new ArrayList<Wrapper>();
        ArrayList<Wrapper> coercibleCandidates = new ArrayList<Wrapper>();
        ArrayList<Wrapper> varArgsCandidates = new ArrayList<Wrapper>();
        int paramCount = paramTypes == null ? 0 : paramTypes.length;
        for (Wrapper w : wrappers) {
            Class<?>[] mParamTypes = w.getParameterTypes();
            int mParamCount = mParamTypes == null ? 0 : mParamTypes.length;
            if (paramCount != mParamCount && (!w.isVarArgs() || paramCount < mParamCount - 1)) continue;
            boolean assignable = false;
            boolean coercible = false;
            boolean varArgs = false;
            boolean noMatch = false;
            block1: for (int i = 0; i < mParamCount; ++i) {
                if (i == mParamCount - 1 && w.isVarArgs()) {
                    varArgs = true;
                    if (mParamCount == paramCount && mParamTypes[i] == paramTypes[i]) continue;
                    Class<?> varType = mParamTypes[i].getComponentType();
                    for (int j = i; j < paramCount; ++j) {
                        if (ReflectionUtil.isAssignableFrom(paramTypes[j], varType) || paramValues != null && j < paramValues.length && ReflectionUtil.isCoercibleFrom(paramValues[j], varType)) continue;
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (mParamTypes[i].equals(paramTypes[i])) continue;
                if (ReflectionUtil.isAssignableFrom(paramTypes[i], mParamTypes[i])) {
                    assignable = true;
                    continue;
                }
                if (paramValues == null || i >= paramValues.length) {
                    noMatch = true;
                    break;
                }
                if (ReflectionUtil.isCoercibleFrom(paramValues[i], mParamTypes[i])) {
                    coercible = true;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (varArgs) {
                varArgsCandidates.add(w);
                continue;
            }
            if (coercible) {
                coercibleCandidates.add(w);
                continue;
            }
            if (assignable) {
                assignableCandidates.add(w);
                continue;
            }
            return w;
        }
        String errorMsg = MessageFactory.get("error.method.ambiguous", clazz, name, ReflectionUtil.paramString(paramTypes));
        if (!assignableCandidates.isEmpty()) {
            return ReflectionUtil.findMostSpecificWrapper(assignableCandidates, paramTypes, false, errorMsg);
        }
        if (!coercibleCandidates.isEmpty()) {
            return ReflectionUtil.findMostSpecificWrapper(coercibleCandidates, paramTypes, true, errorMsg);
        }
        if (!varArgsCandidates.isEmpty()) {
            return ReflectionUtil.findMostSpecificWrapper(varArgsCandidates, paramTypes, true, errorMsg);
        }
        throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", clazz, name, ReflectionUtil.paramString(paramTypes)));
    }

    private static Wrapper findMostSpecificWrapper(List<Wrapper> candidates, Class<?>[] matchingTypes, boolean elSpecific, String errorMsg) {
        ArrayList<Wrapper> ambiguouses = new ArrayList<Wrapper>();
        for (Wrapper candidate : candidates) {
            boolean lessSpecific = false;
            Iterator it = ambiguouses.iterator();
            while (it.hasNext()) {
                int result = ReflectionUtil.isMoreSpecific(candidate, (Wrapper)it.next(), matchingTypes, elSpecific);
                if (result == 1) {
                    it.remove();
                    continue;
                }
                if (result != -1) continue;
                lessSpecific = true;
            }
            if (lessSpecific) continue;
            ambiguouses.add(candidate);
        }
        if (ambiguouses.size() > 1) {
            throw new MethodNotFoundException(errorMsg);
        }
        return (Wrapper)ambiguouses.get(0);
    }

    private static int isMoreSpecific(Wrapper wrapper1, Wrapper wrapper2, Class<?>[] matchingTypes, boolean elSpecific) {
        Class<?>[] paramTypes1 = wrapper1.getParameterTypes();
        Class<?>[] paramTypes2 = wrapper2.getParameterTypes();
        if (wrapper1.isVarArgs()) {
            int length = Math.max(Math.max(paramTypes1.length, paramTypes2.length), matchingTypes.length);
            paramTypes1 = ReflectionUtil.getComparingParamTypesForVarArgsMethod(paramTypes1, length);
            paramTypes2 = ReflectionUtil.getComparingParamTypesForVarArgsMethod(paramTypes2, length);
            if (length > matchingTypes.length) {
                Class[] matchingTypes2 = new Class[length];
                System.arraycopy(matchingTypes, 0, matchingTypes2, 0, matchingTypes.length);
                matchingTypes = matchingTypes2;
            }
        }
        int result = 0;
        for (int i = 0; i < paramTypes1.length; ++i) {
            if (paramTypes1[i] == paramTypes2[i]) continue;
            int r2 = ReflectionUtil.isMoreSpecific(paramTypes1[i], paramTypes2[i], matchingTypes[i], elSpecific);
            if (r2 == 1) {
                if (result == -1) {
                    return 0;
                }
                result = 1;
                continue;
            }
            if (r2 == -1) {
                if (result == 1) {
                    return 0;
                }
                result = -1;
                continue;
            }
            return 0;
        }
        if (result == 0) {
            result = Boolean.compare(wrapper1.isBridge(), wrapper2.isBridge());
        }
        return result;
    }

    private static int isMoreSpecific(Class<?> type1, Class<?> type2, Class<?> matchingType, boolean elSpecific) {
        type1 = ReflectionUtil.getBoxingTypeIfPrimitive(type1);
        if ((type2 = ReflectionUtil.getBoxingTypeIfPrimitive(type2)).isAssignableFrom(type1)) {
            return 1;
        }
        if (type1.isAssignableFrom(type2)) {
            return -1;
        }
        if (elSpecific) {
            if (matchingType != null && Number.class.isAssignableFrom(matchingType)) {
                boolean b2;
                boolean b1 = Number.class.isAssignableFrom(type1) || type1.isPrimitive();
                boolean bl = b2 = Number.class.isAssignableFrom(type2) || type2.isPrimitive();
                if (b1 && !b2) {
                    return 1;
                }
                if (b2 && !b1) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    private static Class<?> getBoxingTypeIfPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            return Double.class;
        }
        return clazz;
    }

    private static Class<?>[] getComparingParamTypesForVarArgsMethod(Class<?>[] paramTypes, int length) {
        Class[] result = new Class[length];
        System.arraycopy(paramTypes, 0, result, 0, paramTypes.length - 1);
        Class<?> type = paramTypes[paramTypes.length - 1].getComponentType();
        for (int i = paramTypes.length - 1; i < length; ++i) {
            result[i] = type;
        }
        return result;
    }

    private static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(types[i].getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        if (src == null) {
            return true;
        }
        target = ReflectionUtil.getBoxingTypeIfPrimitive(target);
        return target.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(Object src, Class<?> target) {
        try {
            ELSupport.coerceToType(src, target);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static Class<?>[] getTypesFromValues(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] == null ? null : values[i].getClass();
        }
        return result;
    }

    static Method getMethod(Class<?> type, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i = 0; i < inf.length; ++i) {
            try {
                mp = inf[i].getMethod(m.getName(), m.getParameterTypes());
                mp = ReflectionUtil.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = ReflectionUtil.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    static Constructor<?> getConstructor(Class<?> type, Constructor<?> c) {
        if (c == null || Modifier.isPublic(type.getModifiers())) {
            return c;
        }
        Constructor<?> cp = null;
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                cp = sup.getConstructor(c.getParameterTypes());
                cp = ReflectionUtil.getConstructor(cp.getDeclaringClass(), cp);
                if (cp != null) {
                    return cp;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    static Object[] buildParameters(ELContext context, Class<?>[] parameterTypes, boolean isVarArgs, Object[] params) {
        Object[] parameters = null;
        if (parameterTypes.length > 0) {
            int paramCount;
            parameters = new Object[parameterTypes.length];
            int n = paramCount = params == null ? 0 : params.length;
            if (isVarArgs) {
                int varArgIndex = parameterTypes.length - 1;
                for (int i = 0; i < varArgIndex && i < paramCount; ++i) {
                    parameters[i] = context.convertToType(params[i], parameterTypes[i]);
                }
                if (parameterTypes.length == paramCount && parameterTypes[varArgIndex] == params[varArgIndex].getClass()) {
                    parameters[varArgIndex] = params[varArgIndex];
                } else {
                    Class<?> varArgClass = parameterTypes[varArgIndex].getComponentType();
                    Object varargs = Array.newInstance(varArgClass, paramCount - varArgIndex);
                    for (int i = varArgIndex; i < paramCount; ++i) {
                        Array.set(varargs, i - varArgIndex, context.convertToType(params[i], varArgClass));
                    }
                    parameters[varArgIndex] = varargs;
                }
            } else {
                for (int i = 0; i < parameterTypes.length && i < paramCount; ++i) {
                    parameters[i] = context.convertToType(params[i], parameterTypes[i]);
                }
            }
        }
        return parameters;
    }

    private static class ConstructorWrapper
    extends Wrapper {
        private final Constructor<?> c;

        public ConstructorWrapper(Constructor<?> c) {
            this.c = c;
        }

        @Override
        public Object unWrap() {
            return this.c;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.c.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.c.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return false;
        }
    }

    private static class MethodWrapper
    extends Wrapper {
        private final Method m;

        public MethodWrapper(Method m) {
            this.m = m;
        }

        @Override
        public Object unWrap() {
            return this.m;
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        public boolean isVarArgs() {
            return this.m.isVarArgs();
        }

        @Override
        public boolean isBridge() {
            return this.m.isBridge();
        }
    }

    private static abstract class Wrapper {
        private Wrapper() {
        }

        public static List<Wrapper> wrap(Method[] methods, String name) {
            ArrayList<Wrapper> result = new ArrayList<Wrapper>();
            for (Method method : methods) {
                if (!method.getName().equals(name)) continue;
                result.add(new MethodWrapper(method));
            }
            return result;
        }

        public static List<Wrapper> wrap(Constructor<?>[] constructors) {
            ArrayList<Wrapper> result = new ArrayList<Wrapper>();
            for (Constructor<?> constructor : constructors) {
                result.add(new ConstructorWrapper(constructor));
            }
            return result;
        }

        public abstract Object unWrap();

        public abstract Class<?>[] getParameterTypes();

        public abstract boolean isVarArgs();

        public abstract boolean isBridge();
    }
}

