/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.concurrent.ManageableThread;
import javax.enterprise.concurrent.ManagedThreadFactory;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.internal.ManagedFutureTask;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;

public class ManagedThreadFactoryImpl
implements ManagedThreadFactory {
    private List<ManagedThread> threads;
    private boolean stopped = false;
    private Lock lock;
    private String name;
    private final ContextSetupProvider contextSetupProvider;
    private final ContextServiceImpl contextService;
    private int priority;
    private long hungTaskThreshold = 0L;
    private boolean longRunningTasks;
    private AtomicInteger threadIdSequence = new AtomicInteger();

    public ManagedThreadFactoryImpl(String name) {
        this(name, null, 5, false);
    }

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService) {
        this(name, contextService, 5, false);
    }

    public ManagedThreadFactoryImpl(String name, ContextServiceImpl contextService, int priority, boolean longRunningTasks) {
        this.name = name;
        this.contextService = contextService;
        this.contextSetupProvider = contextService != null ? contextService.getContextSetupProvider() : null;
        this.priority = priority;
        this.longRunningTasks = longRunningTasks;
        this.threads = new ArrayList<ManagedThread>();
        this.lock = new ReentrantLock();
    }

    public String getName() {
        return this.name;
    }

    public long getHungTaskThreshold() {
        return this.hungTaskThreshold;
    }

    public void setHungTaskThreshold(long hungTaskThreshold) {
        this.hungTaskThreshold = hungTaskThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread newThread(Runnable r) {
        this.lock.lock();
        try {
            if (this.stopped) {
                Thread thread = null;
                return thread;
            }
            ContextHandle contextHandleForSetup = null;
            if (this.contextSetupProvider != null) {
                contextHandleForSetup = this.contextSetupProvider.saveContext(this.contextService);
            }
            ManagedThread newThread = this.createThread(r, contextHandleForSetup);
            newThread.setPriority(this.priority);
            if (this.longRunningTasks) {
                newThread.setDaemon(true);
            }
            this.threads.add(newThread);
            ManagedThread managedThread = newThread;
            return managedThread;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ManagedThread createThread(final Runnable r, final ContextHandle contextHandleForSetup) {
        if (System.getSecurityManager() == null) {
            return new ManagedThread(r, contextHandleForSetup);
        }
        return (ManagedThread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ManagedThread(r, contextHandleForSetup);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeThread(ManagedThread t) {
        this.lock.lock();
        try {
            this.threads.remove(t);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void taskStarting(Thread t, ManagedFutureTask task) {
        if (t instanceof ManagedThread) {
            ManagedThread mt = (ManagedThread)t;
            mt.taskStartTime = System.currentTimeMillis();
            mt.task = task;
        }
    }

    public void taskDone(Thread t) {
        if (t instanceof ManagedThread) {
            ManagedThread mt = (ManagedThread)t;
            mt.taskStartTime = 0L;
            mt.task = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            for (ManagedThread t : this.threads) {
                try {
                    t.shutdown();
                    t.interrupt();
                }
                catch (SecurityException securityException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public class ManagedThread
    extends Thread
    implements ManageableThread {
        volatile long taskStartTime;
        volatile ManagedFutureTask task;
        volatile boolean shutdown;
        final ContextHandle contextHandleForSetup;

        public ManagedThread(Runnable target, ContextHandle contextHandleForSetup) {
            super(target);
            this.taskStartTime = 0L;
            this.task = null;
            this.shutdown = false;
            this.setName(ManagedThreadFactoryImpl.this.name + "-Thread-" + ManagedThreadFactoryImpl.this.threadIdSequence.incrementAndGet());
            this.contextHandleForSetup = contextHandleForSetup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ContextHandle handle = null;
            try {
                if (this.contextHandleForSetup != null) {
                    handle = ManagedThreadFactoryImpl.this.contextSetupProvider.setup(this.contextHandleForSetup);
                }
                super.run();
                if (handle != null) {
                    ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                }
                ManagedThreadFactoryImpl.this.removeThread(this);
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                    if (handle != null) {
                        ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                    }
                    ManagedThreadFactoryImpl.this.removeThread(this);
                }
                catch (Throwable throwable) {
                    if (handle != null) {
                        ManagedThreadFactoryImpl.this.contextSetupProvider.reset(handle);
                    }
                    ManagedThreadFactoryImpl.this.removeThread(this);
                    throw throwable;
                }
            }
        }

        long getTaskRunTime(long now) {
            if (this.taskStartTime > 0L) {
                long taskRunTime = now - this.taskStartTime;
                return taskRunTime > 0L ? taskRunTime : 0L;
            }
            return 0L;
        }

        boolean isTaskHung(long now) {
            if (ManagedThreadFactoryImpl.this.hungTaskThreshold > 0L) {
                return this.getTaskRunTime(now) - ManagedThreadFactoryImpl.this.hungTaskThreshold > 0L;
            }
            return false;
        }

        boolean cancelTask() {
            if (this.task != null) {
                return this.task.cancel(true);
            }
            return false;
        }

        String getTaskIdentityName() {
            if (this.task != null) {
                return this.task.getTaskIdentityName();
            }
            return "null";
        }

        public void shutdown() {
            this.shutdown = true;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }
    }
}

