/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.concurrent;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.glassfish.enterprise.concurrent.internal.ContextProxyInvocationHandler;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.glassfish.enterprise.concurrent.spi.TransactionSetupProvider;

public class ContextServiceImpl
implements ContextService {
    protected final ContextSetupProvider contextSetupProvider;
    protected final TransactionSetupProvider transactionSetupProvider;
    protected final String name;
    private static final String INVALID_PROXY = "contextObject is not a valid contextual object proxy created with the createContextualProxy method";
    private static final String NULL_CONTEXTPROPERTIES = "contextProperties cannot be null";
    private static final String NULL_INSTANCE = "instance cannot be null";
    private static final String NO_INTERFACES = "No interfaces is provided in the method argument";
    private static final String CLASS_DOES_NOT_IMPLEMENT_INTERFACES = "Class does not implement at least one of the provided interfaces";
    private static final String DIFFERENT_CONTEXTSERVICE = "Proxy is created by a different ContextService object";

    public ContextServiceImpl(String name, ContextSetupProvider contextSetupProvider) {
        this(name, contextSetupProvider, null);
    }

    public ContextServiceImpl(String name, ContextSetupProvider contextSetupProvider, TransactionSetupProvider transactionSetupProvider) {
        this.name = name;
        this.contextSetupProvider = contextSetupProvider;
        this.transactionSetupProvider = transactionSetupProvider;
    }

    public String getName() {
        return this.name;
    }

    public ContextSetupProvider getContextSetupProvider() {
        return this.contextSetupProvider;
    }

    public TransactionSetupProvider getTransactionSetupProvider() {
        return this.transactionSetupProvider;
    }

    public Object createContextualProxy(Object instance, Class<?> ... interfaces) {
        return this.createContextualProxy(instance, (Map<String, String>)null, interfaces);
    }

    public Object createContextualProxy(Object instance, Map<String, String> executionProperties, Class<?> ... interfaces) {
        if (instance == null) {
            throw new IllegalArgumentException(NULL_INSTANCE);
        }
        if (interfaces == null || interfaces.length == 0) {
            throw new IllegalArgumentException(NO_INTERFACES);
        }
        Class<?> instanceClass = instance.getClass();
        for (Class<?> thisInterface : interfaces) {
            if (thisInterface.isAssignableFrom(instanceClass)) continue;
            throw new IllegalArgumentException(CLASS_DOES_NOT_IMPLEMENT_INTERFACES);
        }
        ContextProxyInvocationHandler handler = new ContextProxyInvocationHandler(this, instance, executionProperties);
        Object proxy = Proxy.newProxyInstance(instance.getClass().getClassLoader(), interfaces, (InvocationHandler)handler);
        return proxy;
    }

    public <T> T createContextualProxy(T instance, Class<T> intf) {
        return this.createContextualProxy(instance, (Map<String, String>)null, intf);
    }

    public <T> T createContextualProxy(T instance, Map<String, String> executionProperties, Class<T> intf) {
        if (instance == null) {
            throw new IllegalArgumentException(NULL_INSTANCE);
        }
        if (intf == null) {
            throw new IllegalArgumentException(NO_INTERFACES);
        }
        ContextProxyInvocationHandler handler = new ContextProxyInvocationHandler(this, instance, executionProperties);
        Object proxy = Proxy.newProxyInstance(instance.getClass().getClassLoader(), new Class[]{intf}, (InvocationHandler)handler);
        return (T)proxy;
    }

    public Map<String, String> getExecutionProperties(Object contextObject) {
        ContextProxyInvocationHandler handler = this.verifyHandler(contextObject);
        return handler.getExecutionProperties();
    }

    protected void verifyStringValue(Enumeration e) throws ClassCastException {
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
        }
    }

    protected ContextProxyInvocationHandler verifyHandler(Object contextObject) {
        InvocationHandler handler = Proxy.getInvocationHandler(contextObject);
        if (handler instanceof ContextProxyInvocationHandler) {
            ContextProxyInvocationHandler cpih = (ContextProxyInvocationHandler)handler;
            if (cpih.getContextService() != this) {
                throw new IllegalArgumentException(DIFFERENT_CONTEXTSERVICE);
            }
            return cpih;
        }
        throw new IllegalArgumentException(INVALID_PROXY);
    }
}

