/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.util.ConcurrentCache;
import com.sun.faces.util.ExpiringConcurrentCache;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.faces.FacesException;
import javax.faces.view.facelets.FaceletCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultFaceletCache
extends FaceletCache<DefaultFacelet> {
    private final ConcurrentCache<URL, Record> _faceletCache;
    private final ConcurrentCache<URL, Record> _metadataFaceletCache;

    DefaultFaceletCache(final long refreshPeriod) {
        final boolean checkExpiry = refreshPeriod > 0L;
        ConcurrentCache.Factory<URL, Record> faceletFactory = new ConcurrentCache.Factory<URL, Record>(){

            @Override
            public Record newInstance(URL key) throws IOException {
                long lastModified = checkExpiry ? Util.getLastModified(key) : 0L;
                return new Record(System.currentTimeMillis(), lastModified, (DefaultFacelet)DefaultFaceletCache.this.getMemberFactory().newInstance(key), refreshPeriod);
            }
        };
        ConcurrentCache.Factory<URL, Record> metadataFaceletFactory = new ConcurrentCache.Factory<URL, Record>(){

            @Override
            public Record newInstance(URL key) throws IOException {
                long lastModified = checkExpiry ? Util.getLastModified(key) : 0L;
                return new Record(System.currentTimeMillis(), lastModified, (DefaultFacelet)DefaultFaceletCache.this.getMetadataMemberFactory().newInstance(key), refreshPeriod);
            }
        };
        if (refreshPeriod == 0L) {
            this._faceletCache = new NoCache(faceletFactory);
            this._metadataFaceletCache = new NoCache(metadataFaceletFactory);
        } else {
            ExpiringConcurrentCache.ExpiryChecker<URL, Record> checker = refreshPeriod > 0L ? new ExpiryChecker() : new NeverExpired();
            this._faceletCache = new ExpiringConcurrentCache<URL, Record>(faceletFactory, checker);
            this._metadataFaceletCache = new ExpiringConcurrentCache<URL, Record>(metadataFaceletFactory, checker);
        }
    }

    @Override
    public DefaultFacelet getFacelet(URL url) throws IOException {
        Util.notNull("url", url);
        DefaultFacelet f = null;
        try {
            f = this._faceletCache.get(url).getFacelet();
        }
        catch (ExecutionException e) {
            this._unwrapIOException(e);
        }
        return f;
    }

    @Override
    public boolean isFaceletCached(URL url) {
        Util.notNull("url", url);
        return this._faceletCache.containsKey(url);
    }

    @Override
    public DefaultFacelet getViewMetadataFacelet(URL url) throws IOException {
        Util.notNull("url", url);
        DefaultFacelet f = null;
        try {
            f = this._metadataFaceletCache.get(url).getFacelet();
        }
        catch (ExecutionException e) {
            this._unwrapIOException(e);
        }
        return f;
    }

    @Override
    public boolean isViewMetadataFaceletCached(URL url) {
        Util.notNull("url", url);
        return this._metadataFaceletCache.containsKey(url);
    }

    private void _unwrapIOException(ExecutionException e) throws IOException {
        Throwable t = e.getCause();
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new FacesException(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoCache
    extends ConcurrentCache<URL, Record> {
        public NoCache(ConcurrentCache.Factory<URL, Record> f) {
            super(f);
        }

        @Override
        public Record get(URL key) throws ExecutionException {
            try {
                return (Record)this.getFactory().newInstance(key);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public boolean containsKey(URL key) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NeverExpired
    implements ExpiringConcurrentCache.ExpiryChecker<URL, Record> {
        private NeverExpired() {
        }

        @Override
        public boolean isExpired(URL key, Record value) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpiryChecker
    implements ExpiringConcurrentCache.ExpiryChecker<URL, Record> {
        private ExpiryChecker() {
        }

        @Override
        public boolean isExpired(URL url, Record record) {
            long ttl = record.getNextRefreshTime();
            if (System.currentTimeMillis() > ttl) {
                long lastModified = Util.getLastModified(url);
                return lastModified > record.getLastModified();
            }
            return false;
        }
    }

    private static class Record {
        private final long _lastModified;
        private final long _refreshInterval;
        private final long _creationTime;
        private final AtomicLong _nextRefreshTime;
        private final DefaultFacelet _facelet;

        Record(long creationTime, long lastModified, DefaultFacelet facelet, long refreshInterval) {
            this._facelet = facelet;
            this._creationTime = creationTime;
            this._lastModified = lastModified;
            this._refreshInterval = refreshInterval;
            this._nextRefreshTime = this._refreshInterval > 0L ? new AtomicLong(creationTime + refreshInterval) : null;
        }

        DefaultFacelet getFacelet() {
            return this._facelet;
        }

        long getLastModified() {
            return this._lastModified;
        }

        long getNextRefreshTime() {
            return this._refreshInterval > 0L ? this._nextRefreshTime.getAndAdd(this._refreshInterval) : 0L;
        }
    }
}

