/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.faces.context;


import static com.sun.faces.config.WebConfiguration.BooleanWebContextInitParameter.AlwaysPerformValidationWhenRequiredTrue;
import static com.sun.faces.config.WebConfiguration.BooleanWebContextInitParameter.EnableValidateWholeBean;
import static com.sun.faces.config.WebConfiguration.BooleanWebContextInitParameter.ForceAlwaysWriteFlashCookie;
import static com.sun.faces.config.WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving;
import static com.sun.faces.config.WebConfiguration.BooleanWebContextInitParameter.ViewRootPhaseListenerQueuesException;

import java.util.Map;

import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;

import com.sun.faces.RIConstants;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.impl.DefaultResourceResolver;
import com.sun.faces.util.Util;
import javax.faces.component.UIInput;

public class FacesContextFactoryImpl extends FacesContextFactory {



    private final ExceptionHandlerFactory exceptionHandlerFactory;
    private final ExternalContextFactory externalContextFactory;


    // ------------------------------------------------------------ Constructors


    public FacesContextFactoryImpl() {
        super(null);

        exceptionHandlerFactory = (ExceptionHandlerFactory)
              FactoryFinder.getFactory(FactoryFinder.EXCEPTION_HANDLER_FACTORY);
        externalContextFactory = (ExternalContextFactory)
              FactoryFinder.getFactory(FactoryFinder.EXTERNAL_CONTEXT_FACTORY);

    }


    // ---------------------------------------- Methods from FacesContextFactory


    @Override
    public FacesContext getFacesContext(Object sc,
                                        Object request,
                                        Object response,
                                        Lifecycle lifecycle)
    throws FacesException {

        Util.notNull("sc", sc);
        Util.notNull("request", request);
        Util.notNull("response", response);
        Util.notNull("lifecycle", lifecycle);
        ExternalContext extContext;

        FacesContext ctx =
              new FacesContextImpl(
                  extContext = externalContextFactory.getExternalContext(sc, request, response),
                  lifecycle);

        ctx.setExceptionHandler(exceptionHandlerFactory.getExceptionHandler());
        WebConfiguration webConfig = WebConfiguration.getInstance(extContext);

        savePerRequestInitParams(ctx, webConfig);
        return ctx;

    }

    /*
     * Copy the value of any init params that must be checked during
     * this request to our FacesContext attribute map.
     */
    private void savePerRequestInitParams(FacesContext context, WebConfiguration webConfig) {
        ExternalContext extContext = context.getExternalContext();
        Map<String, Object> appMap = extContext.getApplicationMap();
        String val = extContext.getInitParameter(UIComponent.HONOR_CURRENT_COMPONENT_ATTRIBUTES_PARAM_NAME);
        boolean setCurrentComponent = Boolean.valueOf(val);
        Map<Object, Object> attrs = context.getAttributes();
        attrs.put(UIInput.ALWAYS_PERFORM_VALIDATION_WHEN_REQUIRED_IS_TRUE,
                webConfig.isOptionEnabled(AlwaysPerformValidationWhenRequiredTrue) ?
                Boolean.TRUE : Boolean.FALSE);
        attrs.put(UIComponent.HONOR_CURRENT_COMPONENT_ATTRIBUTES_PARAM_NAME,
                setCurrentComponent ? Boolean.TRUE : Boolean.FALSE);
        attrs.put(PartialStateSaving, webConfig.isOptionEnabled(PartialStateSaving) ?
                Boolean.TRUE : Boolean.FALSE);
        attrs.put(ForceAlwaysWriteFlashCookie, webConfig.isOptionEnabled(ForceAlwaysWriteFlashCookie) ?
                Boolean.TRUE : Boolean.FALSE);
        // We must use getQualifiedName here because the consumer is in jsf-api
        // and thus cannot import the enum.
        attrs.put(ViewRootPhaseListenerQueuesException.getQualifiedName(), webConfig.isOptionEnabled(ViewRootPhaseListenerQueuesException) ?
                Boolean.TRUE : Boolean.FALSE);
        attrs.put(EnableValidateWholeBean.getQualifiedName(), webConfig.isOptionEnabled(EnableValidateWholeBean) ?
                Boolean.TRUE : Boolean.FALSE);

        Object nonDefaultResourceResolver = extContext.getApplicationMap().get(DefaultResourceResolver.NON_DEFAULT_RESOURCE_RESOLVER_PARAM_NAME);
        if (null != nonDefaultResourceResolver) {
            attrs.put(DefaultResourceResolver.NON_DEFAULT_RESOURCE_RESOLVER_PARAM_NAME, nonDefaultResourceResolver);
        }
        String facesConfigVersion = "" + appMap.get(RIConstants.FACES_CONFIG_VERSION);
        attrs.put(RIConstants.FACES_CONFIG_VERSION, facesConfigVersion);
    }

    // The testcase for this class is TestSerlvetFacesContextFactory.java

} // end of class FacesContextFactoryImpl
