/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GlassfishUpdater {
    private static final String ASADMIN_NAME = "asadmin";
    private static final String BACKUP_SUFFIX = "jsfbak";
    protected static File libDir = null;
    protected static File modulesDir = null;
    protected static Version version = null;
    protected static boolean printUsageCalled = false;
    private static Map<String, String> mapping = new HashMap<String, String>(2, 1.0f);

    protected GlassfishUpdater() {
    }

    public static void main(String[] args) throws IOException {
        if (0 == args.length) {
            GlassfishUpdater.printUsage();
            return;
        }
        File testFile = null;
        File gfInstallDir = new File(args[0]);
        if (!gfInstallDir.isDirectory()) {
            GlassfishUpdater.printUsage();
            return;
        }
        testFile = new File(gfInstallDir, "bin");
        File[] files = testFile.listFiles();
        boolean foundAsdmin = false;
        for (File cur : files) {
            if (-1 == cur.getName().indexOf(ASADMIN_NAME)) continue;
            foundAsdmin = true;
            break;
        }
        if (!foundAsdmin) {
            GlassfishUpdater.printUsage();
            return;
        }
        modulesDir = new File(gfInstallDir, "modules");
        version = modulesDir.exists() && modulesDir.isDirectory() ? Version.GFv3 : Version.GFv1orv2;
        libDir = new File(gfInstallDir, "lib");
        if (!libDir.isDirectory()) {
            GlassfishUpdater.printUsage();
            return;
        }
        if (GlassfishUpdater.licenseAccepted()) {
            System.out.println("Updating glassfish at\n" + gfInstallDir.toString());
            System.out.println("with new JSF jars.");
            if (Version.GFv1orv2 == version) {
                GlassfishUpdater.stripJsfFromJavaEEJar(libDir);
                GlassfishUpdater.unpackJsfJarsToLib(libDir);
            } else {
                try {
                    GlassfishUpdater.updateV3Jars();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    public static boolean licenseAccepted() throws IOException {
        boolean result = false;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("BINARY_LICENSE.txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while (null != (line = br.readLine())) {
            System.out.println(line);
        }
        System.out.print("Do you accept the above license terms? (type yes or no):");
        br = new BufferedReader(new InputStreamReader(System.in));
        line = br.readLine();
        result = null != line && line.equals("yes");
        return result;
    }

    public static void printUsage() {
        printUsageCalled = true;
        System.err.println("Usage: java -jar glassfish-jsf-update.jar <glassfish install directory>");
        System.err.println("\t<glassfish install directory> is the path to the\n\tglassfish binary install.");
    }

    public static void stripJsfFromJavaEEJar(File libDir) throws IOException {
        if (!GlassfishUpdater.javaEEJarHasJsfClasses(libDir)) {
            return;
        }
        File javaEEJarCopy = new File(libDir, "javaee.jar.copy");
        File javaEEJar = new File(libDir, "javaee.jar");
        File javaEEJarOrig = new File(libDir, GlassfishUpdater.getBackupFilename(libDir, "javaee.jar"));
        javaEEJarCopy.delete();
        JarInputStream origJarStream = new JarInputStream(new FileInputStream(javaEEJar));
        JarOutputStream copyJarStream = new JarOutputStream(new FileOutputStream(javaEEJarCopy));
        JarEntry newEntry = null;
        JarEntry cur = null;
        Pattern pat = Pattern.compile(".*javax.faces.*");
        Matcher mat = null;
        byte[] buf = new byte[1024];
        int n = 0;
        while (null != (cur = origJarStream.getNextJarEntry())) {
            mat = pat.matcher(cur.getName());
            if (mat.matches()) continue;
            newEntry = new JarEntry(cur.getName());
            copyJarStream.putNextEntry(newEntry);
            while ((n = origJarStream.read(buf, 0, buf.length)) != -1) {
                copyJarStream.write(buf, 0, n);
            }
        }
        origJarStream.close();
        copyJarStream.close();
        javaEEJar.renameTo(javaEEJarOrig);
        javaEEJarCopy.renameTo(javaEEJar);
    }

    public static boolean javaEEJarHasJsfClasses(File libDir) throws IOException {
        boolean result = false;
        File javaEEJar = new File(libDir, "javaee.jar");
        JarInputStream origJarStream = new JarInputStream(new FileInputStream(javaEEJar));
        JarEntry cur = null;
        Pattern pat = Pattern.compile(".*javax.faces.*");
        Matcher mat = null;
        cur = origJarStream.getNextJarEntry();
        while (null != cur) {
            mat = pat.matcher(cur.getName());
            if (mat.matches()) {
                result = true;
            }
            cur = origJarStream.getNextJarEntry();
        }
        origJarStream.close();
        return result;
    }

    public static void unpackJsfJarsToLib(File libDir) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("jsf-api.jar");
        File jsfApiCopy = new File(libDir, GlassfishUpdater.getBackupFilename(libDir, "jsf-api.jar"));
        File jsfApi = new File(libDir, "jsf-api.jar");
        File jsfImplCopy = new File(libDir, GlassfishUpdater.getBackupFilename(libDir, "jsf-impl.jar"));
        File jsfImpl = new File(libDir, "jsf-impl.jar");
        jsfApiCopy.delete();
        jsfImplCopy.delete();
        jsfApi.renameTo(jsfApiCopy);
        jsfImpl.renameTo(jsfImplCopy);
        FileOutputStream fos = new FileOutputStream(jsfApi);
        int n = 0;
        while (-1 != (n = is.read())) {
            fos.write(n);
        }
        is.close();
        fos.close();
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("jsf-impl.jar");
        fos = new FileOutputStream(jsfImpl);
        while (-1 != (n = is.read())) {
            fos.write(n);
        }
        is.close();
        fos.close();
    }

    protected static String getBackupFilename(File libDir, String filename) {
        File[] files = libDir.listFiles();
        Pattern pat = Pattern.compile(".*jsfbak[0-9]*");
        Matcher mat = null;
        ArrayList<File> backupFiles = new ArrayList<File>();
        for (File cur : files) {
            mat = pat.matcher(cur.getName());
            if (!mat.matches()) continue;
            backupFiles.add(cur);
        }
        int i = 1;
        int curInt = 0;
        String curSuffix = null;
        String curName = null;
        if (0 < backupFiles.size()) {
            for (File cur : backupFiles) {
                curName = cur.getName();
                curSuffix = curName.substring(curName.indexOf(BACKUP_SUFFIX));
                if (BACKUP_SUFFIX.length() >= curSuffix.length()) continue;
                curInt = Integer.valueOf(curSuffix.substring(BACKUP_SUFFIX.length()));
                if (i == curInt) {
                    i = curInt + 1;
                    continue;
                }
                if (i >= curInt) continue;
                i = curInt;
            }
        }
        return filename + BACKUP_SUFFIX + i;
    }

    private static void updateV3Jars() throws Exception {
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            int n;
            final String targetKey = entry.getKey();
            File modulesDirTmp = "jsf-connector".equals(targetKey) ? new File(modulesDir, "web") : modulesDir;
            String[] files = modulesDirTmp.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(targetKey) && name.endsWith(".jar");
                }
            });
            if (files.length != 1) {
                throw new RuntimeException("Multiple .jar files starting with " + targetKey + ".  Update cannot proceed");
            }
            File f = new File(modulesDirTmp, files[0]);
            String backupName = GlassfishUpdater.getBackupFilename(modulesDirTmp, files[0]);
            File backup = new File(modulesDirTmp, backupName);
            FileInputStream in = new FileInputStream(f);
            FileOutputStream out = new FileOutputStream(backup);
            byte[] buf = new byte[1024];
            int total = in.read(buf);
            while (total != -1) {
                out.write(buf, 0, total);
                total = in.read(buf);
            }
            out.flush();
            out.close();
            in.close();
            String jarSource = entry.getValue();
            String pkg = jarSource.equals("jsf-api.jar") ? "javax/faces" : "com/sun/faces";
            f = new File(modulesDirTmp, files[0]);
            String copyName = files[0] + ".copy";
            File copy = new File(modulesDirTmp, copyName);
            JarInputStream jarIn = new JarInputStream(new FileInputStream(f));
            JarOutputStream jarOut = new JarOutputStream((OutputStream)new FileOutputStream(copy), jarIn.getManifest());
            JarEntry newEntry = null;
            JarEntry cur = null;
            Object mat = null;
            while (null != (cur = jarIn.getNextJarEntry())) {
                if (cur.getName().startsWith(pkg)) continue;
                newEntry = new JarEntry(cur.getName());
                jarOut.putNextEntry(newEntry);
                while ((n = jarIn.read(buf, 0, buf.length)) != -1) {
                    jarOut.write(buf, 0, n);
                }
            }
            jarIn.close();
            jarOut.flush();
            jarOut.close();
            jarIn = new JarInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(jarSource));
            JarInputStream jarInCopy = new JarInputStream(new FileInputStream(copy));
            jarOut = new JarOutputStream((OutputStream)new FileOutputStream(f), jarInCopy.getManifest());
            while (null != (cur = jarIn.getNextJarEntry())) {
                if (cur.getName().contains("MANIFEST.MF") || cur.getName().contains("com.sun.faces.spi.injectionprovider")) continue;
                newEntry = new JarEntry(cur.getName());
                jarOut.putNextEntry(newEntry);
                while ((n = jarIn.read(buf, 0, buf.length)) != -1) {
                    jarOut.write(buf, 0, n);
                }
            }
            while (null != (cur = jarInCopy.getNextJarEntry())) {
                newEntry = new JarEntry(cur.getName());
                try {
                    jarOut.putNextEntry(newEntry);
                }
                catch (Exception e) {
                    continue;
                }
                while ((n = jarInCopy.read(buf, 0, buf.length)) != -1) {
                    jarOut.write(buf, 0, n);
                }
            }
            jarIn.close();
            jarInCopy.close();
            jarOut.flush();
            jarOut.close();
            copy.delete();
        }
    }

    static {
        mapping.put("javax.javaee", "jsf-api.jar");
        mapping.put("jsf-connector", "jsf-impl.jar");
    }

    private static enum Version {
        GFv1orv2,
        GFv3;

    }
}

