/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.glassfish.json.JsonNumberImpl;
import org.glassfish.json.JsonStringImpl;
import org.glassfish.json.JsonWriterImpl;

class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    private final Map<String, JsonValue> valueMap = new LinkedHashMap<String, JsonValue>();

    @Override
    public JsonObjectBuilder add(String name, JsonValue value) {
        this.valueMap.put(name, value);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, String value) {
        this.valueMap.put(name, new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigInteger value) {
        this.valueMap.put(name, new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, BigDecimal value) {
        this.valueMap.put(name, new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, int value) {
        this.valueMap.put(name, new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, long value) {
        this.valueMap.put(name, new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, double value) {
        this.valueMap.put(name, new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, boolean value) {
        this.valueMap.put(name, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonObjectBuilder addNull(String name) {
        this.valueMap.put(name, JsonValue.NULL);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, JsonObjectBuilder builder) {
        this.valueMap.put(name, builder.build());
        return this;
    }

    @Override
    public JsonObjectBuilder add(String name, JsonArrayBuilder builder) {
        this.valueMap.put(name, builder.build());
        return this;
    }

    @Override
    public JsonObject build() {
        LinkedHashMap<String, JsonValue> snapshot = new LinkedHashMap<String, JsonValue>(this.valueMap);
        return new JsonObjectImpl(Collections.unmodifiableMap(snapshot));
    }

    private static final class JsonObjectImpl
    extends AbstractMap<String, JsonValue>
    implements JsonObject {
        private final Map<String, JsonValue> valueMap;

        JsonObjectImpl(Map<String, JsonValue> valueMap) {
            this.valueMap = valueMap;
        }

        @Override
        public <T extends JsonValue> T getValue(String name, Class<T> clazz) {
            return (T)((JsonValue)clazz.cast(this.valueMap.get(name)));
        }

        @Override
        public String getStringValue(String name) {
            return this.getValue(name, JsonString.class).getStringValue();
        }

        @Override
        public String getStringValue(String name, String defaultValue) {
            try {
                return this.getStringValue(name);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public int getIntValue(String name) {
            return this.getValue(name, JsonNumber.class).getIntValue();
        }

        @Override
        public int getIntValue(String name, int defaultValue) {
            try {
                return this.getIntValue(name);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public boolean getBooleanValue(String name) {
            JsonValue value = (JsonValue)this.get(name);
            if (value == null) {
                throw new NullPointerException();
            }
            if (value == JsonValue.TRUE) {
                return true;
            }
            if (value == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        @Override
        public boolean getBooleanValue(String name, boolean defaultValue) {
            try {
                return this.getBooleanValue(name);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.OBJECT;
        }

        @Override
        public Set<Map.Entry<String, JsonValue>> entrySet() {
            return this.valueMap.entrySet();
        }

        @Override
        public String toString() {
            StringWriter sw = new StringWriter();
            JsonWriterImpl jw = new JsonWriterImpl(sw);
            jw.write(this);
            jw.close();
            return sw.toString();
        }
    }
}

