/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;

class JsonStructureParser
implements JsonParser {
    private Scope current;
    private JsonParser.Event state;
    private final Deque<Scope> scopeStack = new ArrayDeque<Scope>();

    JsonStructureParser(JsonArray array) {
        this.current = new ArrayScope(array);
    }

    JsonStructureParser(JsonObject object) {
        this.current = new ObjectScope(object);
    }

    @Override
    public String getString() {
        if (this.state == JsonParser.Event.KEY_NAME) {
            return ((ObjectScope)this.current).key;
        }
        if (this.state == JsonParser.Event.VALUE_STRING) {
            return ((JsonString)this.current.getJsonValue()).getStringValue();
        }
        throw new IllegalStateException("JsonParser#getString() can only be called in KEY_NAME or VALUE_STRING states, not in " + (Object)((Object)this.state));
    }

    @Override
    public JsonNumber.NumberType getNumberType() {
        if (this.state == JsonParser.Event.VALUE_NUMBER) {
            return ((JsonNumber)this.current.getJsonValue()).getNumberType();
        }
        throw new IllegalStateException("JsonParser#getNumberType() can only be called in VALUE_NUMBER state, not in " + (Object)((Object)this.state));
    }

    @Override
    public int getIntValue() {
        if (this.state == JsonParser.Event.VALUE_NUMBER) {
            return ((JsonNumber)this.current.getJsonValue()).getIntValue();
        }
        throw new IllegalStateException("JsonParser#getIntValue() can only be called in VALUE_NUMBER state, not in " + (Object)((Object)this.state));
    }

    @Override
    public long getLongValue() {
        if (this.state == JsonParser.Event.VALUE_NUMBER) {
            return ((JsonNumber)this.current.getJsonValue()).getLongValue();
        }
        throw new IllegalStateException("JsonParser#getLongValue() can only be called in VALUE_NUMBER state, not in " + (Object)((Object)this.state));
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        if (this.state == JsonParser.Event.VALUE_NUMBER) {
            return ((JsonNumber)this.current.getJsonValue()).getBigDecimalValue();
        }
        throw new IllegalStateException("JsonParser#getBigDecimalValue() can only be called in VALUE_NUMBER state, not in " + (Object)((Object)this.state));
    }

    @Override
    public boolean hasNext() {
        return this.state != JsonParser.Event.END_OBJECT && this.state != JsonParser.Event.END_ARRAY || !this.scopeStack.isEmpty();
    }

    @Override
    public JsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.transition();
        return this.state;
    }

    private void transition() {
        if (this.state == null) {
            this.state = this.current instanceof ArrayScope ? JsonParser.Event.START_ARRAY : JsonParser.Event.START_OBJECT;
        } else {
            if (this.state == JsonParser.Event.END_OBJECT || this.state == JsonParser.Event.END_ARRAY) {
                this.current = this.scopeStack.pop();
            }
            if (this.current instanceof ArrayScope) {
                if (this.current.hasNext()) {
                    this.current.next();
                    this.state = JsonStructureParser.getState(this.current.getJsonValue());
                    if (this.state == JsonParser.Event.START_ARRAY || this.state == JsonParser.Event.START_OBJECT) {
                        this.scopeStack.push(this.current);
                        this.current = Scope.createScope(this.current.getJsonValue());
                    }
                } else {
                    this.state = JsonParser.Event.END_ARRAY;
                }
            } else if (this.state == JsonParser.Event.KEY_NAME) {
                this.state = JsonStructureParser.getState(this.current.getJsonValue());
                if (this.state == JsonParser.Event.START_ARRAY || this.state == JsonParser.Event.START_OBJECT) {
                    this.scopeStack.push(this.current);
                    this.current = Scope.createScope(this.current.getJsonValue());
                }
            } else if (this.current.hasNext()) {
                this.current.next();
                this.state = JsonParser.Event.KEY_NAME;
            } else {
                this.state = JsonParser.Event.END_OBJECT;
            }
        }
    }

    @Override
    public void close() {
    }

    private static JsonParser.Event getState(JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                return JsonParser.Event.START_ARRAY;
            }
            case OBJECT: {
                return JsonParser.Event.START_OBJECT;
            }
            case STRING: {
                return JsonParser.Event.VALUE_STRING;
            }
            case NUMBER: {
                return JsonParser.Event.VALUE_NUMBER;
            }
            case TRUE: {
                return JsonParser.Event.VALUE_TRUE;
            }
            case FALSE: {
                return JsonParser.Event.VALUE_FALSE;
            }
            case NULL: {
                return JsonParser.Event.VALUE_NULL;
            }
        }
        throw new JsonException("Unknown value type=" + (Object)((Object)value.getValueType()));
    }

    private static class ObjectScope
    extends Scope {
        private final Iterator<Map.Entry<String, JsonValue>> it;
        private JsonValue value;
        private String key;

        ObjectScope(JsonObject object) {
            this.it = object.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Map.Entry<String, JsonValue> next() {
            Map.Entry<String, JsonValue> next = this.it.next();
            this.key = next.getKey();
            this.value = next.getValue();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        JsonValue getJsonValue() {
            return this.value;
        }
    }

    private static class ArrayScope
    extends Scope {
        private final Iterator<JsonValue> it;
        private JsonValue value;

        ArrayScope(JsonArray array) {
            this.it = array.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public JsonValue next() {
            this.value = this.it.next();
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        JsonValue getJsonValue() {
            return this.value;
        }
    }

    private static abstract class Scope
    implements Iterator {
        private Scope() {
        }

        abstract JsonValue getJsonValue();

        static Scope createScope(JsonValue value) {
            if (value instanceof JsonArray) {
                return new ArrayScope((JsonArray)value);
            }
            if (value instanceof JsonObject) {
                return new ObjectScope((JsonObject)value);
            }
            throw new JsonException("Cannot be called for value=" + value);
        }
    }
}

