/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonParser;
import org.glassfish.json.JsonArrayBuilderImpl;
import org.glassfish.json.JsonObjectBuilderImpl;
import org.glassfish.json.JsonParserImpl;

class JsonReaderImpl
implements JsonReader {
    private final JsonParser parser;
    private boolean readDone;

    JsonReaderImpl(Reader reader) {
        this(reader, Collections.emptyMap());
    }

    private JsonReaderImpl(Reader reader, Map<String, ?> config) {
        this.parser = new JsonParserImpl(reader);
    }

    JsonReaderImpl(InputStream in) {
        this(in, Collections.emptyMap());
    }

    private JsonReaderImpl(InputStream in, Map<String, ?> config) {
        this.parser = new JsonParserImpl(in);
    }

    JsonReaderImpl(InputStream in, Charset charset) {
        this(in, charset, Collections.emptyMap());
    }

    private JsonReaderImpl(InputStream in, Charset charset, Map<String, ?> config) {
        this.parser = new JsonParserImpl(in, charset);
    }

    @Override
    public JsonStructure read() {
        if (this.readDone) {
            throw new IllegalStateException("read/readObject/readArray/close method is already called.");
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            if (e == JsonParser.Event.START_ARRAY) {
                return this.readArray(new JsonArrayBuilderImpl());
            }
            if (e == JsonParser.Event.START_OBJECT) {
                return this.readObject(new JsonObjectBuilderImpl());
            }
            throw new JsonException("Cannot read JSON, parsing error. Parsing Event=" + (Object)((Object)e));
        }
        throw new JsonException("Cannot read JSON, possibly empty stream");
    }

    @Override
    public JsonObject readObject() {
        if (this.readDone) {
            throw new IllegalStateException("read/readObject/readArray/close method is already called.");
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            if (e == JsonParser.Event.START_OBJECT) {
                return this.readObject(new JsonObjectBuilderImpl());
            }
            if (e == JsonParser.Event.START_ARRAY) {
                throw new JsonException("Cannot read JSON object, found JSON array");
            }
            throw new JsonException("Cannot read JSON object, parsing error. Parsing Event=" + (Object)((Object)e));
        }
        throw new JsonException("Cannot read JSON object, possibly empty stream");
    }

    @Override
    public JsonArray readArray() {
        if (this.readDone) {
            throw new IllegalStateException("read/readObject/readArray/close method is already called.");
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            if (e == JsonParser.Event.START_ARRAY) {
                return this.readArray(new JsonArrayBuilderImpl());
            }
            if (e == JsonParser.Event.START_OBJECT) {
                throw new JsonException("Cannot read JSON array, found JSON object");
            }
            throw new JsonException("Cannot read JSON array, parsing error. Parsing Event=" + (Object)((Object)e));
        }
        throw new JsonException("Cannot read JSON array, possibly empty stream");
    }

    @Override
    public void close() {
        this.readDone = true;
        this.parser.close();
    }

    private JsonArray readArray(JsonArrayBuilder builder) {
        block10: while (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            switch (e) {
                case START_ARRAY: {
                    JsonArray array = this.readArray(new JsonArrayBuilderImpl());
                    builder.add(array);
                    continue block10;
                }
                case START_OBJECT: {
                    JsonObject object = this.readObject(new JsonObjectBuilderImpl());
                    builder.add(object);
                    continue block10;
                }
                case VALUE_STRING: {
                    String string = this.parser.getString();
                    builder.add(string);
                    continue block10;
                }
                case VALUE_NUMBER: {
                    BigDecimal bd = this.parser.getBigDecimal();
                    builder.add(bd);
                    continue block10;
                }
                case VALUE_TRUE: {
                    builder.add(true);
                    continue block10;
                }
                case VALUE_FALSE: {
                    builder.add(false);
                    continue block10;
                }
                case VALUE_NULL: {
                    builder.addNull();
                    continue block10;
                }
                case END_ARRAY: {
                    return builder.build();
                }
            }
            throw new JsonException("Internal Error");
        }
        throw new JsonException("Internal Error");
    }

    private JsonObject readObject(JsonObjectBuilder builder) {
        String key = null;
        block11: while (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            switch (e) {
                case START_ARRAY: {
                    JsonArray array = this.readArray(new JsonArrayBuilderImpl());
                    builder.add(key, array);
                    continue block11;
                }
                case START_OBJECT: {
                    JsonObject object = this.readObject(new JsonObjectBuilderImpl());
                    builder.add(key, object);
                    continue block11;
                }
                case KEY_NAME: {
                    key = this.parser.getString();
                    continue block11;
                }
                case VALUE_STRING: {
                    String string = this.parser.getString();
                    builder.add(key, string);
                    continue block11;
                }
                case VALUE_NUMBER: {
                    BigDecimal bd = this.parser.getBigDecimal();
                    builder.add(key, bd);
                    continue block11;
                }
                case VALUE_TRUE: {
                    builder.add(key, true);
                    continue block11;
                }
                case VALUE_FALSE: {
                    builder.add(key, false);
                    continue block11;
                }
                case VALUE_NULL: {
                    builder.addNull(key);
                    continue block11;
                }
                case END_OBJECT: {
                    return builder.build();
                }
            }
            throw new JsonException("Internal Error");
        }
        throw new JsonException("Internal Error");
    }
}

