/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.json.JsonException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParsingException;
import org.glassfish.json.JsonLocationImpl;

final class JsonTokenizer
implements Closeable {
    private boolean unread;
    private int prevChar;
    private long lineNo = 1L;
    private long columnNo = 1L;
    private long streamOffset = 0L;
    private final Reader reader;
    private char[] buf = new char[4096];
    private int readBegin;
    private int readEnd;
    private int storeBegin;
    private int storeEnd;
    private boolean minus;
    private boolean fracOrExp;
    private String value;
    private BigDecimal bd;

    JsonTokenizer(Reader reader) {
        this.reader = reader;
    }

    private int read() {
        int ch;
        if (this.unread) {
            this.unread = false;
            ch = this.prevChar;
        } else {
            ch = this.readChar();
        }
        if (ch == 13 || this.prevChar != 13 && ch == 10) {
            ++this.lineNo;
            this.columnNo = 1L;
        } else if (this.prevChar != 13 || ch != 10) {
            ++this.columnNo;
        }
        ++this.streamOffset;
        this.prevChar = ch;
        return ch;
    }

    private void unread(int ch) {
        this.prevChar = ch;
        this.unread = true;
        --this.streamOffset;
        --this.columnNo;
    }

    private void readString() {
        int ch;
        this.storeBegin = this.storeEnd = this.readBegin;
        boolean escaped = false;
        do {
            ch = this.read();
            block0 : switch (ch) {
                case -1: {
                    throw new JsonException("Unexpected EOF");
                }
                case 92: {
                    escaped = true;
                    int ch2 = this.read();
                    switch (ch2) {
                        case 98: {
                            this.buf[this.storeEnd++] = 8;
                            break block0;
                        }
                        case 116: {
                            this.buf[this.storeEnd++] = 9;
                            break block0;
                        }
                        case 110: {
                            this.buf[this.storeEnd++] = 10;
                            break block0;
                        }
                        case 102: {
                            this.buf[this.storeEnd++] = 12;
                            break block0;
                        }
                        case 114: {
                            this.buf[this.storeEnd++] = 13;
                            break block0;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            this.buf[this.storeEnd++] = (char)ch2;
                            break block0;
                        }
                        case 117: {
                            int unicode = 0;
                            for (int i = 0; i < 4; ++i) {
                                int ch3 = this.read();
                                unicode = (char)(unicode << 4);
                                if (ch3 >= 48 && ch3 <= 57) {
                                    unicode = (char)(unicode | (char)ch3 - 48);
                                    continue;
                                }
                                if (ch3 >= 97 && ch3 <= 102) {
                                    unicode = (char)(unicode | (char)ch3 - 97 + 10);
                                    continue;
                                }
                                if (ch3 >= 65 && ch3 <= 70) {
                                    unicode = (char)(unicode | (char)ch3 - 65 + 10);
                                    continue;
                                }
                                throw new JsonParsingException("Unexpected Char=" + ch3, this.getLastCharLocation());
                            }
                            this.buf[this.storeEnd++] = (char)(unicode & 0xFFFF);
                            break block0;
                        }
                    }
                    throw new JsonParsingException("Unexpected Char=" + ch2, this.getLastCharLocation());
                }
                case 34: {
                    break;
                }
                default: {
                    if (ch >= 0 && ch <= 31 || ch >= 127 && ch <= 159) {
                        throw new JsonException("Unexpected Char=" + ch);
                    }
                    if (!escaped) {
                        ++this.storeEnd;
                        break;
                    }
                    this.buf[this.storeEnd++] = (char)ch;
                }
            }
        } while (ch != 34);
    }

    private void readNumber(int ch) {
        int count;
        this.storeEnd = this.readBegin - 1;
        this.storeBegin = this.storeEnd++;
        if (ch == 45) {
            this.minus = true;
            ch = this.read();
            if (ch < 48 || ch > 57) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        if (ch == 48) {
            ++this.storeEnd;
            ch = this.read();
        } else {
            do {
                ++this.storeEnd;
            } while ((ch = this.read()) >= 48 && ch <= 57);
        }
        if (ch == 46) {
            this.fracOrExp = true;
            count = 0;
            do {
                ++this.storeEnd;
                ch = this.read();
                ++count;
            } while (ch >= 48 && ch <= 57);
            if (count == 1) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        if (ch == 101 || ch == 69) {
            ++this.storeEnd;
            this.fracOrExp = true;
            ch = this.read();
            if (ch == 43 || ch == 45) {
                ++this.storeEnd;
                ch = this.read();
            }
            count = 0;
            while (ch >= 48 && ch <= 57) {
                ++this.storeEnd;
                ch = this.read();
                ++count;
            }
            if (count == 0) {
                throw new JsonParsingException("Unexpected Char=" + ch, this.getLastCharLocation());
            }
        }
        this.unread(ch);
    }

    private void readTrue() {
        char ch1 = (char)this.read();
        if (ch1 != 'r') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'r'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'u') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'u'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 'e') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 'e'", this.getLastCharLocation());
        }
    }

    private void readFalse() {
        char ch1 = (char)this.read();
        if (ch1 != 'a') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'a'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'l'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 's') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 's'", this.getLastCharLocation());
        }
        char ch4 = (char)this.read();
        if (ch4 != 'e') {
            throw new JsonParsingException("Unexpected Char=" + ch4 + " expecting 'e'", this.getLastCharLocation());
        }
    }

    private void readNull() {
        char ch1 = (char)this.read();
        if (ch1 != 'u') {
            throw new JsonParsingException("Unexpected Char=" + ch1 + " expecting 'u'", this.getLastCharLocation());
        }
        char ch2 = (char)this.read();
        if (ch2 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch2 + " expecting 'l'", this.getLastCharLocation());
        }
        char ch3 = (char)this.read();
        if (ch3 != 'l') {
            throw new JsonParsingException("Unexpected Char=" + ch3 + " expecting 'l'", this.getLastCharLocation());
        }
    }

    JsonToken nextToken() throws IOException {
        this.reset();
        int ch = this.read();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            ch = this.read();
        }
        switch (ch) {
            case 34: {
                this.readString();
                return JsonToken.STRING;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 116: {
                this.readTrue();
                return JsonToken.TRUE;
            }
            case 102: {
                this.readFalse();
                return JsonToken.FALSE;
            }
            case 110: {
                this.readNull();
                return JsonToken.NULL;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readNumber(ch);
                return JsonToken.NUMBER;
            }
            case -1: {
                return JsonToken.EOF;
            }
        }
        throw new JsonParsingException("Unexpected char=" + (char)ch, this.getLastCharLocation());
    }

    JsonLocation getLastCharLocation() {
        return new JsonLocationImpl(this.lineNo, this.columnNo - 1L, this.streamOffset - 1L);
    }

    JsonLocation getLocation() {
        return new JsonLocationImpl(this.lineNo, this.columnNo, this.streamOffset);
    }

    private int readChar() {
        try {
            if (this.readBegin == this.readEnd) {
                if (this.storeEnd - this.storeBegin == this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, 2 * this.buf.length);
                } else if (this.storeEnd - this.storeBegin > 0) {
                    System.arraycopy(this.buf, this.storeBegin, this.buf, 0, this.storeEnd - this.storeBegin);
                    this.storeEnd -= this.storeBegin;
                    this.storeBegin = 0;
                }
                int len = this.reader.read(this.buf, this.storeEnd, this.buf.length - this.storeEnd);
                if (len == -1) {
                    return -1;
                }
                assert (len != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + len;
            }
            return this.buf[this.readBegin++];
        }
        catch (IOException ioe) {
            throw new JsonException("I/O error while tokenizing JSON", ioe);
        }
    }

    private void reset() {
        this.storeBegin = 0;
        this.storeEnd = 0;
        this.value = null;
        this.bd = null;
        this.minus = false;
        this.fracOrExp = false;
    }

    String getValue() {
        if (this.value == null) {
            this.value = new String(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.value;
    }

    BigDecimal getBigDecimal() {
        if (this.bd == null) {
            this.bd = new BigDecimal(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.bd;
    }

    int getInt() {
        int storeLen = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (storeLen <= 9 || this.minus && storeLen == 10)) {
            int i;
            int num = 0;
            int n = i = this.minus ? 1 : 0;
            while (i < storeLen) {
                num = num * 10 + (this.buf[this.storeBegin + i] - 48);
                ++i;
            }
            return this.minus ? -num : num;
        }
        return this.getBigDecimal().intValue();
    }

    boolean isIntegral() {
        return !this.fracOrExp || this.getBigDecimal().scale() == 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static enum JsonToken {
        CURLYOPEN,
        SQUAREOPEN,
        COLON,
        COMMA,
        STRING,
        NUMBER,
        TRUE,
        FALSE,
        NULL,
        CURLYCLOSE,
        SQUARECLOSE,
        EOF;

    }
}

