/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import com.sun.tools.jxc.ApBasedTask;
import com.sun.tools.jxc.ap.SchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.Processor;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class SchemaGenBase
extends ApBasedTask {
    private final List<Schema> schemas = new ArrayList<Schema>();
    private File episode = null;
    private boolean fork = false;
    private final CommandlineJava cmd = new CommandlineJava();
    private Path modulepath = null;
    private Path modulesourcepath = null;
    private Path upgrademodulepath = null;
    private String addmodules = null;
    private String limitmodules = null;
    private String addreads = null;
    private String addexports = null;
    private String patchmodule = null;
    private String addopens = null;

    CommandlineJava getCommandline() {
        return this.cmd;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmd.createVmArgument();
    }

    public void setModulepath(Path mp) {
        this.modulepath = mp;
    }

    public Path getModulepath() {
        return this.modulepath;
    }

    public void setModulesourcepath(Path msp) {
        this.modulesourcepath = msp;
    }

    public Path getModulesourcepath() {
        return this.modulesourcepath;
    }

    public void setUpgrademodulepath(Path ump) {
        this.upgrademodulepath = ump;
    }

    public Path getUpgrademodulepath() {
        return this.upgrademodulepath;
    }

    public void setAddmodules(String ams) {
        this.addmodules = ams;
    }

    public String getAddmodules() {
        return this.addmodules;
    }

    public void setLimitmodules(String lms) {
        this.limitmodules = lms;
    }

    public String getLimitmodules() {
        return this.limitmodules;
    }

    public void setAddreads(String ars) {
        this.addreads = ars;
    }

    public String getAddreads() {
        return this.addreads;
    }

    public void setAddexports(String aes) {
        this.addexports = aes;
    }

    public String getAddexports() {
        return this.addexports;
    }

    public void setPatchmodule(String pms) {
        this.patchmodule = pms;
    }

    public String getPatchmodule() {
        return this.patchmodule;
    }

    public void setAddopens(String aos) {
        this.addopens = aos;
    }

    public String getAddopens() {
        return this.addopens;
    }

    @Override
    protected void setupCommandlineSwitches(Commandline cmd) {
        cmd.createArgument().setValue("-proc:only");
    }

    @Override
    protected String getCompilationMessage() {
        return "Generating schema from ";
    }

    @Override
    protected String getFailedMessage() {
        return "schema generation failed";
    }

    public void setFork(boolean flg) {
        this.fork = flg;
    }

    public boolean getFork() {
        return this.fork;
    }

    public Schema createSchema() {
        Schema s = new Schema();
        this.schemas.add(s);
        return s;
    }

    public void setEpisode(File f) {
        this.episode = f;
    }

    public File getEpisode() {
        return this.episode;
    }

    @Override
    protected Processor getProcessor() {
        HashMap<String, File> m = new HashMap<String, File>();
        for (Schema schema : this.schemas) {
            if (m.containsKey(schema.namespace)) {
                throw new BuildException("the same namespace is specified twice");
            }
            m.put(schema.namespace, schema.file);
        }
        SchemaGenerator r = new SchemaGenerator(m);
        if (this.episode != null) {
            r.setEpisodeFile(this.episode);
        }
        return r;
    }

    @Override
    protected void compile() {
        try {
            if (this.getFork()) {
                this.setupCommand();
                this.setupForkCommand("com.sun.tools.jxc.SchemaGeneratorFacade");
                int status = this.run(this.getCommandline().getCommandline());
                if (status != 0) {
                    if (!this.getVerbose()) {
                        this.log("Command invoked: schemagen" + this.getCommandline().toString());
                    }
                    throw new BuildException("schemagen failed", this.getLocation());
                }
            } else {
                super.compile();
            }
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)((Object)ex);
            }
            throw new BuildException("Error starting schemagen: " + ex.getMessage(), (Throwable)ex, this.getLocation());
        }
    }

    protected CommandlineJava setupCommand() {
        if (null != this.getDestdir() && !this.getDestdir().getName().equals("")) {
            this.getCommandline().createArgument().setValue("-d");
            this.getCommandline().createArgument().setFile(this.getDestdir());
        }
        if (this.getEpisode() != null && this.getEpisode().exists() && this.getEpisode().isFile()) {
            this.getCommandline().createArgument().setValue("-episode");
            this.getCommandline().createArgument().setFile(this.getEpisode());
        }
        if (this.getEncoding() != null) {
            this.getCommandline().createArgument().setValue("-encoding");
            this.getCommandline().createArgument().setValue(this.getEncoding());
        }
        if (this.getVerbose()) {
            this.getCommandline().createArgument().setValue("-verbose");
        }
        if (this.compileList != null && this.compileList.length > 0) {
            for (File aCompileList : this.compileList) {
                String arg = aCompileList.getAbsolutePath();
                this.getCommandline().createArgument().setValue(arg);
            }
        }
        return this.getCommandline();
    }

    void setupForkCommand(String className) {
        ClassLoader loader;
        for (loader = ((Object)((Object)this)).getClass().getClassLoader(); loader != null && !(loader instanceof AntClassLoader); loader = loader.getParent()) {
        }
        String antcp = loader != null ? ((AntClassLoader)loader).getClasspath() : System.getProperty("java.class.path");
        File jreHome = new File(System.getProperty("java.home"));
        File toolsJar = new File(jreHome.getParent(), "lib/tools.jar");
        if (toolsJar.exists()) {
            antcp = antcp + File.pathSeparatorChar + toolsJar.getAbsolutePath();
        }
        this.cmd.createClasspath(this.getProject()).append(new Path(this.getProject(), antcp));
        this.cmd.setClassname(className);
    }

    private int run(String[] command) throws BuildException {
        LogStreamHandler logstr = new LogStreamHandler((Task)this, 2, 1);
        Execute exe = new Execute((ExecuteStreamHandler)logstr);
        exe.setAntRun(this.getProject());
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public class Schema {
        private String namespace;
        private File file;

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setFile(String fileName) {
            File dest = SchemaGenBase.this.getDestdir();
            if (dest == null) {
                dest = SchemaGenBase.this.getProject().getBaseDir();
            }
            this.file = new File(dest, fileName);
        }
    }
}

