/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.bean;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.generator.annotation.spec.XmlElementDeclWriter;
import com.sun.tools.xjc.generator.annotation.spec.XmlRegistryWriter;
import com.sun.tools.xjc.generator.bean.BeanGenerator;
import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.generator.bean.Messages;
import com.sun.tools.xjc.generator.bean.ObjectFactoryGenerator;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Constructor;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.FieldAccessor;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.xml.bind.v2.TODO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.namespace.QName;

abstract class ObjectFactoryGeneratorImpl
extends ObjectFactoryGenerator {
    private final BeanGenerator outline;
    private final Model model;
    private final JCodeModel codeModel;
    private final JClass classRef;
    private final JDefinedClass objectFactory;
    private final HashMap<QName, JFieldVar> qnameMap = new HashMap();
    private final Map<String, CElementInfo> elementFactoryNames = new HashMap<String, CElementInfo>();
    private final Map<String, ClassOutlineImpl> valueFactoryNames = new HashMap<String, ClassOutlineImpl>();

    @Override
    public JDefinedClass getObjectFactory() {
        return this.objectFactory;
    }

    public ObjectFactoryGeneratorImpl(BeanGenerator outline, Model model, JPackage targetPackage) {
        this.outline = outline;
        this.model = model;
        this.codeModel = this.model.codeModel;
        this.classRef = this.codeModel.ref(Class.class);
        this.objectFactory = this.outline.getClassFactory().createClass((JClassContainer)targetPackage, "ObjectFactory", null);
        this.objectFactory.annotate2(XmlRegistryWriter.class);
        JMethod m1 = this.objectFactory.constructor(1);
        m1.javadoc().append((Object)("Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: " + targetPackage.name()));
        this.objectFactory.javadoc().append((Object)("This object contains factory methods for each \nJava content interface and Java element interface \ngenerated in the " + targetPackage.name() + " package. \n" + "<p>An ObjectFactory allows you to programatically \n" + "construct new instances of the Java representation \n" + "for XML content. The Java representation of XML \n" + "content can consist of schema derived interfaces \n" + "and classes representing the binding of schema \n" + "type definitions, element declarations and model \n" + "groups.  Factory methods for each of these are \n" + "provided in this class."));
    }

    protected final void populate(CElementInfo ei, Aspect impl, Aspect exposed) {
        CElementInfo existing;
        JType exposedElementType = ei.toType(this.outline, exposed);
        JType exposedType = ei.getContentInMemoryType().toType(this.outline, exposed);
        JType implType = ei.getContentInMemoryType().toType(this.outline, impl);
        String namespaceURI = ei.getElementName().getNamespaceURI();
        String localPart = ei.getElementName().getLocalPart();
        JDefinedClass scope = null;
        if (ei.getScope() != null) {
            scope = this.outline.getClazz((CClassInfo)ei.getScope()).implClass;
        }
        if (ei.isAbstract()) {
            TODO.checkSpec();
        }
        if ((existing = this.elementFactoryNames.put(ei.getSqueezedName(), ei)) != null) {
            this.outline.getErrorReceiver().error(existing.getLocator(), Messages.OBJECT_FACTORY_CONFLICT.format(ei.getSqueezedName()));
            this.outline.getErrorReceiver().error(ei.getLocator(), Messages.OBJECT_FACTORY_CONFLICT_RELATED.format(new Object[0]));
            return;
        }
        JMethod m = this.objectFactory.method(1, exposedElementType, "create" + ei.getSqueezedName());
        JVar $value = m.param(exposedType, "value");
        Object declaredType = implType.boxify().isParameterized() || !exposedType.equals(implType) ? JExpr.cast((JType)this.classRef, (JExpression)implType.boxify().dotclass()) : implType.boxify().dotclass();
        JExpression scopeClass = scope == null ? JExpr._null() : scope.dotclass();
        JInvocation exp = JExpr._new((JType)exposedElementType);
        if (!ei.hasClass()) {
            exp.arg(this.getQNameInvocation(ei));
            exp.arg((JExpression)declaredType);
            exp.arg(scopeClass);
        }
        if (implType == exposedType) {
            exp.arg((JExpression)$value);
        } else {
            exp.arg((JExpression)JExpr.cast((JType)implType, (JExpression)$value));
        }
        m.body()._return((JExpression)exp);
        m.javadoc().append((Object)"Create an instance of ").append((Object)exposedElementType);
        m.javadoc().addParam($value).append((Object)"Java instance representing xml element's value.");
        m.javadoc().addReturn().append((Object)"the new instance of ").append((Object)exposedElementType);
        XmlElementDeclWriter xemw = (XmlElementDeclWriter)m.annotate2(XmlElementDeclWriter.class);
        xemw.namespace(namespaceURI).name(localPart);
        if (scope != null) {
            xemw.scope((JType)scope);
        }
        if (ei.getSubstitutionHead() != null) {
            QName n = ei.getSubstitutionHead().getElementName();
            xemw.substitutionHeadNamespace(n.getNamespaceURI());
            xemw.substitutionHeadName(n.getLocalPart());
        }
        if (ei.getDefaultValue() != null) {
            xemw.defaultValue(ei.getDefaultValue());
        }
        if (ei.getProperty().inlineBinaryData()) {
            m.annotate(XmlInlineBinaryData.class);
        }
        this.outline.generateAdapterIfNecessary(ei.getProperty(), (JAnnotatable)m);
    }

    private JExpression getQNameInvocation(CElementInfo ei) {
        QName name = ei.getElementName();
        if (this.qnameMap.containsKey(name)) {
            return (JExpression)this.qnameMap.get(name);
        }
        if (this.qnameMap.size() > 1024) {
            return this.createQName(name);
        }
        JFieldVar qnameField = this.objectFactory.field(28, QName.class, '_' + ei.getSqueezedName() + "_QNAME", (JExpression)this.createQName(name));
        this.qnameMap.put(name, qnameField);
        return qnameField;
    }

    private JInvocation createQName(QName name) {
        return JExpr._new((JClass)this.codeModel.ref(QName.class)).arg(name.getNamespaceURI()).arg(name.getLocalPart());
    }

    protected final void populate(ClassOutlineImpl cc, JClass sigType) {
        String name;
        ClassOutlineImpl classOutlineImpl;
        Collection<? extends Constructor> consl;
        if (!cc.target.isAbstract()) {
            JMethod m = this.objectFactory.method(1, (JType)sigType, "create" + cc.target.getSqueezedName());
            m.body()._return((JExpression)JExpr._new((JClass)cc.implRef));
            m.javadoc().append((Object)"Create an instance of ").append((Object)cc.ref);
        }
        if ((consl = cc.target.getConstructors()).size() != 0) {
            cc.implClass.constructor(1);
        }
        if ((classOutlineImpl = this.valueFactoryNames.put(name = cc.target.getSqueezedName(), cc)) != null) {
            this.outline.getErrorReceiver().error(classOutlineImpl.target.getLocator(), Messages.OBJECT_FACTORY_CONFLICT.format(name));
            this.outline.getErrorReceiver().error(cc.target.getLocator(), Messages.OBJECT_FACTORY_CONFLICT_RELATED.format(new Object[0]));
            return;
        }
        for (Constructor constructor : consl) {
            JMethod m = this.objectFactory.method(1, (JType)cc.ref, "create" + cc.target.getSqueezedName());
            JInvocation inv = JExpr._new((JClass)cc.implRef);
            m.body()._return((JExpression)inv);
            m.javadoc().append((Object)"Create an instance of ").append((Object)cc.ref).addThrows(JAXBException.class).append((Object)"if an error occurs");
            JMethod c = cc.implClass.constructor(1);
            for (String fieldName : constructor.fields) {
                CPropertyInfo field = cc.target.getProperty(fieldName);
                if (field == null) {
                    this.outline.getErrorReceiver().error(cc.target.getLocator(), Messages.ILLEGAL_CONSTRUCTOR_PARAM.format(fieldName));
                    continue;
                }
                fieldName = ObjectFactoryGeneratorImpl.camelize(fieldName);
                FieldOutline fo = this.outline.getField(field);
                FieldAccessor accessor = fo.create(JExpr._this());
                inv.arg((JExpression)m.param(fo.getRawType(), fieldName));
                JVar $var = c.param(fo.getRawType(), fieldName);
                accessor.fromRawValue(c.body(), '_' + fieldName, (JExpression)$var);
            }
        }
    }

    private static String camelize(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }
}

