/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2.model;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.txw2.NameUtil;
import com.sun.tools.txw2.TxwOptions;
import com.sun.tools.txw2.model.Define;
import com.sun.tools.txw2.model.Element;
import com.sun.tools.txw2.model.Grammar;
import com.sun.tools.txw2.model.Leaf;
import com.sun.tools.txw2.model.Ref;
import com.sun.tools.txw2.model.WriterNode;
import com.sun.xml.txw2.annotation.XmlNamespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class NodeSet
extends LinkedHashSet<WriterNode> {
    final TxwOptions opts;
    final JCodeModel codeModel;
    private final Set<Element> rootElements = new HashSet<Element>();
    final String defaultNamespace;

    public NodeSet(TxwOptions opts, Leaf entry) {
        this.opts = opts;
        this.codeModel = opts.codeModel;
        this.addAll(entry.siblings());
        this.markRoot(entry.siblings(), this.rootElements);
        HashSet<String> ns = new HashSet<String>();
        for (Element e : this.rootElements) {
            ns.add(e.name.getNamespaceURI());
        }
        if (ns.size() != 1 || opts.noPackageNamespace || opts._package.isUnnamed()) {
            this.defaultNamespace = null;
        } else {
            this.defaultNamespace = (String)ns.iterator().next();
            opts._package.annotate(XmlNamespace.class).param("value", this.defaultNamespace);
        }
    }

    private void markRoot(Iterable<Leaf> c, Set<Element> rootElements) {
        for (Leaf l : c) {
            if (l instanceof Element) {
                Element e = (Element)l;
                rootElements.add(e);
                e.isRoot = true;
            }
            if (!(l instanceof Ref)) continue;
            this.markRoot(((Ref)l).def, rootElements);
        }
    }

    private void addAll(Iterable<Leaf> c) {
        for (Leaf l : c) {
            if (l instanceof Element && this.add((Element)l)) {
                this.addAll((Element)l);
            }
            if (l instanceof Grammar) {
                Grammar g = (Grammar)l;
                for (Define d : g.getDefinitions()) {
                    this.add(d);
                }
            }
            if (!(l instanceof Ref)) continue;
            Ref r = (Ref)l;
            Define def = r.def;
            this.add(def);
        }
    }

    @Override
    private boolean add(Define def) {
        boolean b = super.add(def);
        if (b) {
            this.addAll(def);
        }
        return b;
    }

    public <T extends WriterNode> Collection<T> subset(Class<T> t) {
        ArrayList<WriterNode> r = new ArrayList<WriterNode>(this.size());
        for (WriterNode n : this) {
            if (!t.isInstance(n)) continue;
            r.add(n);
        }
        return r;
    }

    public void write(TxwOptions opts) {
        for (WriterNode n : this) {
            n.prepare(this);
        }
        for (WriterNode n : this) {
            n.declare(this);
        }
        for (WriterNode n : this) {
            n.generate(this);
        }
    }

    final JDefinedClass createClass(String name) {
        try {
            return this.opts._package._class(1, NameUtil.toClassName(name), ClassType.INTERFACE);
        }
        catch (JClassAlreadyExistsException e) {
            int i = 2;
            while (true) {
                try {
                    return this.opts._package._class(1, NameUtil.toClassName(name + String.valueOf(i)), ClassType.INTERFACE);
                }
                catch (JClassAlreadyExistsException e1) {
                    ++i;
                    continue;
                }
                break;
            }
        }
    }
}

