/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.SingleStreamCodeWriter;
import com.sun.tools.rngom.parse.Parseable;
import com.sun.tools.rngom.parse.compact.CompactParseable;
import com.sun.tools.rngom.parse.xml.SAXParseable;
import com.sun.tools.txw2.BadCommandLineException;
import com.sun.tools.txw2.ErrorListener;
import com.sun.tools.txw2.RELAXNGLoader;
import com.sun.tools.txw2.SchemaBuilder;
import com.sun.tools.txw2.XmlSchemaLoader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class TxwOptions {
    public final JCodeModel codeModel = new JCodeModel();
    public JPackage _package;
    public ErrorListener errorListener;
    CodeWriter codeWriter;
    SchemaBuilder source;
    public boolean chainMethod;
    public boolean noPackageNamespace;
    public Language language;
    public boolean disableXmlSecurity;

    void parseArguments(String[] args) throws BadCommandLineException {
        String src = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) {
                throw new BadCommandLineException(TxwOptions.getMessage("missingOperand", new Object[0]));
            }
            if (args[i].charAt(0) == '-') {
                int j = this.parseArgument(args, i);
                if (j == 0) {
                    throw new BadCommandLineException(TxwOptions.getMessage("unrecognizedParameter", args[i]));
                }
                i += j - 1;
                continue;
            }
            src = args[i];
        }
        if (this._package == null) {
            this._package = this.codeModel.rootPackage();
        }
        if (this.codeWriter == null) {
            this.codeWriter = new SingleStreamCodeWriter((OutputStream)System.out);
        }
        if (src == null) {
            throw new BadCommandLineException(TxwOptions.getMessage("missingOperand", new Object[0]));
        }
        try {
            this.source = this.makeSourceSchema(src, this.errorListener);
        }
        catch (MalformedURLException mue) {
            throw new BadCommandLineException(mue.getMessage(), mue);
        }
    }

    private int parseArgument(String[] args, int i) throws BadCommandLineException {
        if (args[i].equals("-o")) {
            File targetDir = new File(this.requireArgument("-o", args, ++i));
            try {
                this.codeWriter = new FileCodeWriter(targetDir);
            }
            catch (IOException ex) {
                throw new BadCommandLineException(ex.getMessage(), ex);
            }
            return 2;
        }
        if (args[i].equals("-p")) {
            this._package = this.codeModel._package(this.requireArgument("-p", args, ++i));
            return 2;
        }
        if (args[i].equals("-c")) {
            this.language = Language.COMPACT;
            return 1;
        }
        if (args[i].equals("-x")) {
            this.language = Language.XML;
            return 1;
        }
        if (args[i].equals("-xsd")) {
            this.language = Language.XMLSCHEMA;
            return 1;
        }
        if (args[i].equals("-h")) {
            this.chainMethod = true;
            return 1;
        }
        if (args[i].equals("-disableXmlSecurity")) {
            this.disableXmlSecurity = true;
            return 1;
        }
        return 0;
    }

    private String requireArgument(String d, String[] args, int i) throws BadCommandLineException {
        if (i == args.length || args[i].startsWith("-")) {
            throw new BadCommandLineException(TxwOptions.getMessage("missingOperand", new Object[0]));
        }
        return args[i];
    }

    public void printUsage() {
        System.out.println(TxwOptions.getMessage("usage", new Object[0]));
    }

    private SchemaBuilder makeSourceSchema(String src, ErrorHandler eh) throws BadCommandLineException, MalformedURLException {
        File f = new File(src);
        InputSource in = new InputSource(f.toURI().toURL().toExternalForm());
        if (this.language == null) {
            this.language = in.getSystemId().endsWith(".rnc") ? Language.COMPACT : (in.getSystemId().endsWith(".rng") ? Language.XML : Language.XMLSCHEMA);
        }
        SchemaBuilder sb = null;
        switch (this.language) {
            case XMLSCHEMA: {
                sb = new XmlSchemaLoader(in);
                break;
            }
            case COMPACT: {
                sb = new RELAXNGLoader((Parseable)new CompactParseable(in, eh));
                break;
            }
            case XML: {
                sb = new RELAXNGLoader((Parseable)new SAXParseable(in, eh));
                break;
            }
            default: {
                throw new BadCommandLineException(TxwOptions.getMessage("unknownGrammar", new Object[0]));
            }
        }
        return sb;
    }

    public static String getVersion() {
        try {
            Properties p = new Properties();
            p.load(TxwOptions.class.getResourceAsStream("version.properties"));
            return p.get("version").toString();
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    private static String getMessage(String key, Object ... args) {
        String msg = ResourceBundle.getBundle(TxwOptions.class.getPackage().getName() + ".messages").getString(key);
        return MessageFormat.format(msg, args);
    }

    public static enum Language {
        XML,
        XMLSCHEMA,
        COMPACT;

    }
}

