/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.txw2;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.FilterCodeWriter;
import com.sun.tools.rngom.parse.Parseable;
import com.sun.tools.rngom.parse.compact.CompactParseable;
import com.sun.tools.rngom.parse.xml.SAXParseable;
import com.sun.tools.txw2.AntErrorListener;
import com.sun.tools.txw2.Main;
import com.sun.tools.txw2.RELAXNGLoader;
import com.sun.tools.txw2.TxwOptions;
import com.sun.tools.txw2.XmlSchemaLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class TxwTask
extends Task {
    private final TxwOptions options = new TxwOptions();
    private File schemaFile;
    private Style style = Style.AUTO_DETECT;
    private File license;
    private String encoding;
    private File destDir;

    public TxwTask() {
        this.options._package = this.options.codeModel.rootPackage();
        try {
            this.options.codeWriter = new FileCodeWriter(new File("."));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setPackage(String pkg) {
        this.options._package = this.options.codeModel._package(pkg);
    }

    public void setSyntax(String style) {
        this.style = Style.valueOf(style.toUpperCase());
    }

    public void setSchema(File schema) {
        this.schemaFile = schema;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setMethodChaining(boolean flg) {
        this.options.chainMethod = flg;
    }

    public void setLicense(File license) {
        this.license = license;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        try {
            this.options.codeWriter = new FileCodeWriter(this.destDir, this.encoding != null ? this.encoding : StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        if (this.license != null) {
            this.options.codeWriter = new LicenseCodeWriter(this.options.codeWriter, this.license, this.encoding != null ? this.encoding : StandardCharsets.UTF_8.name());
        }
        this.options.errorListener = new AntErrorListener(this.getProject());
        cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            in = new InputSource(this.schemaFile.toURI().toURL().toExternalForm());
            msg = "Compiling: " + in.getSystemId();
            this.log(msg, 2);
            if (this.style == Style.AUTO_DETECT) {
                fileName = this.schemaFile.getPath().toLowerCase();
                this.style = fileName.endsWith("rnc") != false ? Style.COMPACT : (fileName.endsWith("xsd") != false ? Style.XMLSCHEMA : Style.XML);
            }
            switch (1.$SwitchMap$com$sun$tools$txw2$TxwTask$Style[this.style.ordinal()]) {
                case 1: {
                    this.options.source = new RELAXNGLoader((Parseable)new CompactParseable(in, (ErrorHandler)this.options.errorListener));
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.options.source = new RELAXNGLoader((Parseable)new SAXParseable(in, (ErrorHandler)this.options.errorListener));
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.options.source = new XmlSchemaLoader(in);
                    break;
                }
                ** default:
lbl31:
                // 1 sources

                break;
            }
        }
        catch (MalformedURLException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        Main.run(this.options);
        this.log("Compilation complete.", 2);
    }

    private static final class LicenseCodeWriter
    extends FilterCodeWriter {
        private static final String COPYRIGHT_LINE_TEMPLATE = "^.*Copyright \\(c\\) (YYYY) (by )?([A-Za-z].*)$";
        private static final Pattern PATTERN = Pattern.compile("^.*Copyright \\(c\\) (YYYY) (by )?([A-Za-z].*)$", 8);
        private static final String CURRENT_YEAR = String.valueOf(Calendar.getInstance().get(1));
        private final Path license;

        LicenseCodeWriter(CodeWriter core, File license, String encoding) {
            super(core);
            this.license = license.toPath();
            this.encoding = encoding;
        }

        public Writer openSource(JPackage pkg, String fileName) throws IOException {
            Writer w = super.openSource(pkg, fileName);
            PrintWriter out = new PrintWriter(w);
            try (BufferedReader br = Files.newBufferedReader(this.license, Charset.forName(this.encoding));){
                String line;
                while ((line = br.readLine()) != null) {
                    Matcher m = PATTERN.matcher(line);
                    if (m.matches()) {
                        out.write(line, 0, m.start(1));
                        out.write(CURRENT_YEAR);
                        out.write(line, m.end(1), line.length() - m.end(1));
                    } else {
                        out.write(line);
                    }
                    out.write(System.lineSeparator());
                }
            }
            out.flush();
            return w;
        }
    }

    private static enum Style {
        COMPACT,
        XML,
        XMLSCHEMA,
        AUTO_DETECT;

    }
}

