/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

abstract class AbstractJavaResourceMethodDispatcher
implements ResourceMethodDispatcher {
    @Inject
    private Provider<ConfiguredValidator> validatorProvider;
    private final Method method;
    private final InvocationHandler methodHandler;
    private Invocable resourceMethod;

    AbstractJavaResourceMethodDispatcher(Invocable resourceMethod, InvocationHandler methodHandler) {
        this.method = resourceMethod.getHandlingMethod();
        this.methodHandler = methodHandler;
        this.resourceMethod = resourceMethod;
    }

    @Override
    public final Response dispatch(Object resource, Request request) throws ProcessingException {
        return this.doDispatch(resource, request);
    }

    protected abstract Response doDispatch(Object var1, Request var2) throws ProcessingException;

    final Object invoke(Object resource, Object ... args) throws ProcessingException {
        try {
            ConfiguredValidator validator = (ConfiguredValidator)this.validatorProvider.get();
            if (validator != null) {
                validator.validateResourceAndInputParams(resource, this.resourceMethod, args);
            }
            Object invocationResult = this.methodHandler.invoke(resource, this.method, args);
            if (validator != null) {
                validator.validateResult(resource, this.resourceMethod, invocationResult);
            }
            return invocationResult;
        }
        catch (IllegalAccessException ex) {
            throw new ProcessingException("Resource Java method invocation error.", ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            throw new MappableException(cause);
        }
        catch (UndeclaredThrowableException ex) {
            throw new ProcessingException("Resource Java method invocation error.", ex);
        }
        catch (ProcessingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MappableException(ex);
        }
        catch (Throwable t) {
            throw new ProcessingException(t);
        }
    }

    public String toString() {
        return this.method.toString();
    }
}

