/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Registration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.servlet.WebComponent;
import org.glassfish.jersey.servlet.init.internal.LocalizationMessages;

@HandlesTypes(value={Path.class, Provider.class, Application.class, ApplicationPath.class})
public class JerseyServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(JerseyServletContainerInitializer.class.getName());

    public void onStartup(Set<Class<?>> classes, ServletContext sc) throws ServletException {
        if (classes == null) {
            classes = Collections.emptySet();
        }
        for (Class<? extends Application> a : this.getApplicationClasses(classes)) {
            ServletRegistration appReg = sc.getServletRegistration(a.getName());
            if (appReg != null) {
                this.addServletWithExistingRegistration(sc, appReg, a, classes);
                continue;
            }
            List<Registration> srs = this.getInitParamDeclaredRegistrations(sc, a);
            if (!srs.isEmpty()) {
                for (Registration sr : srs) {
                    if (!(sr instanceof ServletRegistration)) continue;
                    this.addServletWithExistingRegistration(sc, (ServletRegistration)sr, a, classes);
                }
                continue;
            }
            this.addServletWithApplication(sc, a, classes);
        }
        this.addServletWithDefaultConfiguration(sc, classes);
    }

    private List<Registration> getInitParamDeclaredRegistrations(ServletContext sc, Class<? extends Application> a) {
        ArrayList srs = Lists.newArrayList();
        this.collectJaxRsRegistrations(sc.getServletRegistrations(), srs, a);
        this.collectJaxRsRegistrations(sc.getFilterRegistrations(), srs, a);
        return srs;
    }

    private void collectJaxRsRegistrations(Map<String, ? extends Registration> registrations, List<Registration> collected, Class<? extends Application> a) {
        for (Registration registration : registrations.values()) {
            Map ips = registration.getInitParameters();
            if (!ips.containsKey("javax.ws.rs.Application") || !((String)ips.get("javax.ws.rs.Application")).equals(a.getName())) continue;
            collected.add(registration);
        }
    }

    private void addServletWithDefaultConfiguration(ServletContext sc, Set<Class<?>> classes) throws ServletException {
        ServletRegistration appReg = sc.getServletRegistration(Application.class.getName());
        if (appReg != null && appReg.getClassName() == null) {
            Set<Class<?>> appClasses = this.getRootResourceAndProviderClasses(classes);
            ServletContainer s = new ServletContainer(ResourceConfig.forApplicationClass(ResourceConfig.class, appClasses).addProperties(JerseyServletContainerInitializer.getInitParams(appReg)).addProperties(WebComponent.getContextParams(sc)));
            if ((appReg = sc.addServlet(appReg.getName(), (Servlet)s)).getMappings().isEmpty()) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.JERSEY_APP_NO_MAPPING(appReg.getName()));
            } else {
                LOGGER.log(Level.INFO, LocalizationMessages.JERSEY_APP_REGISTERED_CLASSES(appReg.getName(), appClasses));
            }
        }
    }

    private void addServletWithApplication(ServletContext sc, Class<? extends Application> a, Set<Class<?>> classes) throws ServletException {
        ApplicationPath ap = a.getAnnotation(ApplicationPath.class);
        if (ap != null) {
            ResourceConfig rc = ResourceConfig.forApplicationClass(a, classes);
            ServletContainer s = new ServletContainer(rc);
            ServletRegistration.Dynamic dsr = sc.addServlet(a.getName(), (Servlet)s);
            dsr.setAsyncSupported(true);
            String mapping = this.createMappingPath(ap);
            if (!this.mappingExists(sc, mapping)) {
                dsr.addMapping(new String[]{mapping});
                LOGGER.log(Level.INFO, LocalizationMessages.JERSEY_APP_REGISTERED_MAPPING(a.getName(), mapping));
            } else {
                LOGGER.log(Level.SEVERE, LocalizationMessages.JERSEY_APP_MAPPING_CONFLICT(a.getName(), mapping));
            }
        }
    }

    private void addServletWithExistingRegistration(ServletContext sc, ServletRegistration sr, Class<? extends Application> a, Set<Class<?>> classes) throws ServletException {
        if (sr.getClassName() == null) {
            ResourceConfig rc = ResourceConfig.forApplicationClass(a, classes).addProperties(JerseyServletContainerInitializer.getInitParams(sr)).addProperties(WebComponent.getContextParams(sc));
            ServletContainer s = new ServletContainer(rc);
            ServletRegistration.Dynamic dsr = sc.addServlet(a.getName(), (Servlet)s);
            dsr.setAsyncSupported(true);
            if (dsr.getMappings().isEmpty()) {
                ApplicationPath ap = a.getAnnotation(ApplicationPath.class);
                if (ap != null) {
                    String mapping = this.createMappingPath(ap);
                    if (!this.mappingExists(sc, mapping)) {
                        dsr.addMapping(new String[]{mapping});
                        LOGGER.log(Level.INFO, LocalizationMessages.JERSEY_APP_REGISTERED_MAPPING(a.getName(), mapping));
                    } else {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.JERSEY_APP_MAPPING_CONFLICT(a.getName(), mapping));
                    }
                } else {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.JERSEY_APP_NO_MAPPING_OR_ANNOTATION(a.getName(), ApplicationPath.class.getSimpleName()));
                }
            } else {
                LOGGER.log(Level.INFO, LocalizationMessages.JERSEY_APP_REGISTERED_APPLICATION(a.getName()));
            }
        }
    }

    private static Map<String, Object> getInitParams(ServletRegistration sr) {
        HashMap initParams = Maps.newHashMap();
        for (Map.Entry entry : sr.getInitParameters().entrySet()) {
            initParams.put(entry.getKey(), entry.getValue());
        }
        return initParams;
    }

    private boolean mappingExists(ServletContext sc, String mapping) {
        for (ServletRegistration sr : sc.getServletRegistrations().values()) {
            for (String declaredMapping : sr.getMappings()) {
                if (!mapping.equals(declaredMapping)) continue;
                return true;
            }
        }
        return false;
    }

    private String createMappingPath(ApplicationPath ap) {
        String path = ap.value();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/*")) {
            path = path.endsWith("/") ? path + "*" : path + "/*";
        }
        return path;
    }

    private Set<Class<? extends Application>> getApplicationClasses(Set<Class<?>> classes) {
        LinkedHashSet<Class<? extends Application>> s = new LinkedHashSet<Class<? extends Application>>();
        for (Class<?> c : classes) {
            if (Application.class == c || !Application.class.isAssignableFrom(c)) continue;
            s.add(c.asSubclass(Application.class));
        }
        return s;
    }

    private Set<Class<?>> getRootResourceAndProviderClasses(Set<Class<?>> classes) {
        LinkedHashSet s = new LinkedHashSet();
        for (Class<?> c : classes) {
            if (!c.isAnnotationPresent(Path.class) && !c.isAnnotationPresent(Provider.class)) continue;
            s.add(c);
        }
        return s;
    }
}

