/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring.jmx;

import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.ws.rs.ProcessingException;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.monitoring.jmx.ApplicationMXBeanImpl;
import org.glassfish.jersey.server.internal.monitoring.jmx.ExceptionMapperMXBeanImpl;
import org.glassfish.jersey.server.internal.monitoring.jmx.ExecutionStatisticsDynamicBean;
import org.glassfish.jersey.server.internal.monitoring.jmx.ResourcesMBeanGroup;
import org.glassfish.jersey.server.internal.monitoring.jmx.ResponseMXBeanImpl;
import org.glassfish.jersey.server.monitoring.ApplicationStatistics;
import org.glassfish.jersey.server.monitoring.MonitoringStatistics;
import org.glassfish.jersey.server.monitoring.MonitoringStatisticsListener;
import org.glassfish.jersey.server.monitoring.ResourceStatistics;

public class MBeanExposer
implements MonitoringStatisticsListener {
    private static final String PROPERTY_SUBTYPE_GLOBAL = "Global";
    static final String PROPERTY_EXECUTION_TIMES_REQUESTS = "RequestTimes";
    static final String PROPERTY_EXECUTION_TIMES_METHODS = "MethodTimes";
    private volatile ExecutionStatisticsDynamicBean requestMBean;
    private volatile ResponseMXBeanImpl responseMXBean;
    private volatile ResourcesMBeanGroup uriStatsGroup;
    private volatile ResourcesMBeanGroup resourceClassStatsGroup;
    private volatile ExceptionMapperMXBeanImpl exceptionMapperMXBean;
    private final AtomicBoolean exposed = new AtomicBoolean(false);
    private volatile String domain;
    private static final Logger LOGGER = Logger.getLogger(MBeanExposer.class.getName());

    private Map<String, ResourceStatistics> transformToStringKeys(Map<Class<?>, ResourceStatistics> stats) {
        HashMap newMap = Maps.newHashMap();
        for (Map.Entry<Class<?>, ResourceStatistics> entry : stats.entrySet()) {
            newMap.put(entry.getKey().getName(), entry.getValue());
        }
        return newMap;
    }

    void registerMBean(Object mbean, String namePostfix) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        String name = this.domain + namePostfix;
        try {
            ObjectName objectName = new ObjectName(name);
            if (mBeanServer.isRegistered(objectName)) {
                LOGGER.log(Level.WARNING, LocalizationMessages.WARNING_MONITORING_MBEANS_BEAN_ALREADY_REGISTERED(objectName));
                mBeanServer.unregisterMBean(objectName);
            }
            mBeanServer.registerMBean(mbean, objectName);
        }
        catch (JMException e) {
            throw new ProcessingException(LocalizationMessages.ERROR_MONITORING_MBEANS_REGISTRATION(name), e);
        }
    }

    private void unregisterJerseyMBeans() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> names = mBeanServer.queryNames(new ObjectName(this.domain + ",*"), null);
            for (ObjectName name : names) {
                mBeanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_MONITORING_MBEANS_UNREGISTRATION_DESTROY(), e);
        }
    }

    @Override
    public void onStatistics(MonitoringStatistics statistics) {
        if (this.exposed.compareAndSet(false, true)) {
            String globalSubType = ",subType=Global";
            ApplicationStatistics appStats = statistics.getApplicationStatistics();
            String appName = appStats.getResourceConfig().getApplicationName();
            if (appName == null) {
                appName = "App_" + Integer.toHexString(appStats.getResourceConfig().hashCode());
            }
            this.domain = "org.glassfish.jersey:type=" + appName;
            this.unregisterJerseyMBeans();
            this.uriStatsGroup = new ResourcesMBeanGroup(statistics.getUriStatistics(), true, this, ",subType=Uris");
            Map<String, ResourceStatistics> newMap = this.transformToStringKeys(statistics.getResourceClassStatistics());
            this.resourceClassStatsGroup = new ResourcesMBeanGroup(newMap, false, this, ",subType=Resources");
            this.responseMXBean = new ResponseMXBeanImpl();
            this.registerMBean(this.responseMXBean, ",subType=Global,global=Responses");
            this.requestMBean = new ExecutionStatisticsDynamicBean(statistics.getRequestStatistics(), this, ",subType=Global", "AllRequestTimes");
            this.exceptionMapperMXBean = new ExceptionMapperMXBeanImpl(statistics.getExceptionMapperStatistics(), this, ",subType=Global");
            new ApplicationMXBeanImpl(appStats, this, ",subType=Global");
        }
        if (statistics.getApplicationStatistics().getDestroyTime() != null) {
            this.unregisterJerseyMBeans();
        }
        this.requestMBean.updateExecutionStatistics(statistics.getRequestStatistics());
        this.uriStatsGroup.updateResourcesStatistics(statistics.getUriStatistics());
        this.responseMXBean.updateResponseStatistics(statistics.getResponseStatistics());
        this.exceptionMapperMXBean.updateExceptionMapperStatistics(statistics.getExceptionMapperStatistics());
        this.resourceClassStatsGroup.updateResourcesStatistics(this.transformToStringKeys(statistics.getResourceClassStatistics()));
    }
}

