/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.NameBinding;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.model.NameBound;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.model.Consuming;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.Producing;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.Suspendable;
import org.glassfish.jersey.uri.PathPattern;

public final class ResourceMethod
implements ResourceModelComponent,
Producing,
Consuming,
Suspendable,
NameBound {
    private final Data data;
    private final Resource parent;

    static List<ResourceMethod> transform(final Resource parent, List<Data> list) {
        return Lists.transform(list, (Function)new Function<Data, ResourceMethod>(){

            public ResourceMethod apply(Data data) {
                return data == null ? null : new ResourceMethod(parent, data);
            }
        });
    }

    ResourceMethod(Resource parent, Data data) {
        this.parent = parent;
        this.data = data;
    }

    Data getData() {
        return this.data;
    }

    public Resource getParent() {
        return this.parent;
    }

    public JaxrsType getType() {
        return this.data.getType();
    }

    public String getHttpMethod() {
        return this.data.getHttpMethod();
    }

    public Invocable getInvocable() {
        return this.data.getInvocable();
    }

    @Override
    public List<MediaType> getConsumedTypes() {
        return this.data.getConsumedTypes();
    }

    @Override
    public List<MediaType> getProducedTypes() {
        return this.data.getProducedTypes();
    }

    @Override
    public long getSuspendTimeout() {
        return this.data.getSuspendTimeout();
    }

    @Override
    public TimeUnit getSuspendTimeoutUnit() {
        return this.data.getSuspendTimeoutUnit();
    }

    @Override
    public boolean isSuspendDeclared() {
        return this.data.isSuspended();
    }

    @Override
    public boolean isManagedAsyncDeclared() {
        return this.data.isManagedAsync();
    }

    @Override
    public List<? extends ResourceModelComponent> getComponents() {
        return Arrays.asList(this.data.getInvocable());
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitResourceMethod(this);
    }

    @Override
    public boolean isNameBound() {
        return !this.data.getNameBindings().isEmpty();
    }

    @Override
    public Collection<Class<? extends Annotation>> getNameBindings() {
        return this.data.getNameBindings();
    }

    public String toString() {
        return "ResourceMethod{" + this.data.toString() + '}';
    }

    static class Data {
        private final JaxrsType type;
        private final String httpMethod;
        private final List<MediaType> consumedTypes;
        private final List<MediaType> producedTypes;
        private final boolean managedAsync;
        private final boolean suspended;
        private final long suspendTimeout;
        private final TimeUnit suspendTimeoutUnit;
        private final Invocable invocable;
        private final Collection<Class<? extends Annotation>> nameBindings;

        private Data(String httpMethod, Collection<MediaType> consumedTypes, Collection<MediaType> producedTypes, boolean managedAsync, boolean suspended, long suspendTimeout, TimeUnit suspendTimeoutUnit, Invocable invocable, Collection<Class<? extends Annotation>> nameBindings) {
            this.managedAsync = managedAsync;
            this.type = JaxrsType.classify(httpMethod);
            this.httpMethod = httpMethod == null ? httpMethod : httpMethod.toUpperCase();
            this.consumedTypes = Collections.unmodifiableList(Lists.newArrayList(consumedTypes));
            this.producedTypes = Collections.unmodifiableList(Lists.newArrayList(producedTypes));
            this.invocable = invocable;
            this.suspended = suspended;
            this.suspendTimeout = suspendTimeout;
            this.suspendTimeoutUnit = suspendTimeoutUnit;
            this.nameBindings = Collections.unmodifiableCollection(Lists.newArrayList(nameBindings));
        }

        JaxrsType getType() {
            return this.type;
        }

        String getHttpMethod() {
            return this.httpMethod;
        }

        List<MediaType> getConsumedTypes() {
            return this.consumedTypes;
        }

        List<MediaType> getProducedTypes() {
            return this.producedTypes;
        }

        boolean isManagedAsync() {
            return this.managedAsync;
        }

        boolean isSuspended() {
            return this.suspended;
        }

        long getSuspendTimeout() {
            return this.suspendTimeout;
        }

        TimeUnit getSuspendTimeoutUnit() {
            return this.suspendTimeoutUnit;
        }

        Invocable getInvocable() {
            return this.invocable;
        }

        Collection<Class<? extends Annotation>> getNameBindings() {
            return this.nameBindings;
        }

        public String toString() {
            return "httpMethod=" + this.httpMethod + ", consumedTypes=" + this.consumedTypes + ", producedTypes=" + this.producedTypes + ", suspended=" + this.suspended + ", suspendTimeout=" + this.suspendTimeout + ", suspendTimeoutUnit=" + (Object)((Object)this.suspendTimeoutUnit) + ", invocable=" + this.invocable + ", nameBindings=" + this.nameBindings;
        }
    }

    public static final class Builder {
        private final Resource.Builder parent;
        private String httpMethod;
        private final Set<MediaType> consumedTypes;
        private final Set<MediaType> producedTypes;
        private boolean managedAsync;
        private boolean suspended;
        private long suspendTimeout;
        private TimeUnit suspendTimeoutUnit;
        private Class<?> handlerClass;
        private Object handlerInstance;
        private Method handlingMethod;
        private Method validateMethod;
        private boolean encodedParams;
        private final Collection<Class<? extends Annotation>> nameBindings;

        Builder(Resource.Builder parent) {
            this.parent = parent;
            this.httpMethod = null;
            this.consumedTypes = Sets.newLinkedHashSet();
            this.producedTypes = Sets.newLinkedHashSet();
            this.suspended = false;
            this.suspendTimeout = 0L;
            this.suspendTimeoutUnit = TimeUnit.MILLISECONDS;
            this.encodedParams = false;
            this.nameBindings = Sets.newLinkedHashSet();
        }

        public Builder httpMethod(String name) {
            this.httpMethod = name;
            return this;
        }

        public Builder produces(String ... types) {
            return this.produces(MediaTypes.createFrom(types));
        }

        public Builder produces(MediaType ... types) {
            return this.produces(Arrays.asList(types));
        }

        public Builder produces(Collection<MediaType> types) {
            this.producedTypes.addAll(types);
            return this;
        }

        public Builder consumes(String ... types) {
            return this.consumes(MediaTypes.createFrom(types));
        }

        public Builder consumes(MediaType ... types) {
            return this.consumes(Arrays.asList(types));
        }

        public Builder consumes(Collection<MediaType> types) {
            this.consumedTypes.addAll(types);
            return this;
        }

        public Builder nameBindings(Collection<Class<? extends Annotation>> nameBindings) {
            for (Class<? extends Annotation> nameBinding : nameBindings) {
                if (nameBinding.getAnnotation(NameBinding.class) == null) continue;
                this.nameBindings.add(nameBinding);
            }
            return this;
        }

        public Builder nameBindings(Class<? extends Annotation> ... nameBindings) {
            return this.nameBindings(Arrays.asList(nameBindings));
        }

        public Builder nameBindings(Annotation ... nameBindings) {
            return this.nameBindings(Collections2.transform(Arrays.asList(nameBindings), (Function)new Function<Annotation, Class<? extends Annotation>>(){

                public Class<? extends Annotation> apply(Annotation input) {
                    return input.annotationType();
                }
            }));
        }

        public Builder suspended(long timeout, TimeUnit unit) {
            this.suspended = true;
            this.suspendTimeout = timeout;
            this.suspendTimeoutUnit = unit;
            return this;
        }

        public Builder managedAsync() {
            this.managedAsync = true;
            return this;
        }

        public Builder encodedParameters(boolean value) {
            this.encodedParams = value;
            return this;
        }

        public Builder handledBy(Class<?> handlerClass, Method method) {
            this.handlerInstance = null;
            this.handlerClass = handlerClass;
            this.handlingMethod = method;
            return this;
        }

        public Builder handledBy(Object handlerInstance, Method method) {
            this.handlerClass = null;
            this.handlerInstance = handlerInstance;
            this.handlingMethod = method;
            return this;
        }

        public Builder handledBy(Inflector<ContainerRequestContext, ?> inflector) {
            return this.handledBy(inflector, Invocable.APPLY_INFLECTOR_METHOD);
        }

        public Builder handledBy(Class<? extends Inflector> inflectorClass) {
            return this.handledBy(inflectorClass, Invocable.APPLY_INFLECTOR_METHOD);
        }

        public Builder validateUsing(Method validateMethod) {
            this.validateMethod = validateMethod;
            return this;
        }

        public ResourceMethod build() {
            Data methodData = new Data(this.httpMethod, this.consumedTypes, this.producedTypes, this.managedAsync, this.suspended, this.suspendTimeout, this.suspendTimeoutUnit, this.createInvocable(), this.nameBindings);
            this.parent.onBuildMethod(this, methodData);
            return new ResourceMethod(null, methodData);
        }

        private Invocable createInvocable() {
            assert (this.handlerClass != null || this.handlerInstance != null);
            MethodHandler handler = this.handlerClass != null ? MethodHandler.create(this.handlerClass, this.encodedParams) : MethodHandler.create(this.handlerInstance);
            if (this.validateMethod == null) {
                return Invocable.create(handler, this.handlingMethod, this.encodedParams);
            }
            return Invocable.create(handler, this.handlingMethod, this.validateMethod, this.encodedParams);
        }
    }

    public static enum JaxrsType {
        RESOURCE_METHOD{

            @Override
            PathPattern createPatternFor(String pathTemplate) {
                return PathPattern.END_OF_PATH_PATTERN;
            }
        }
        ,
        SUB_RESOURCE_METHOD{

            @Override
            PathPattern createPatternFor(String pathTemplate) {
                return new PathPattern(pathTemplate, PathPattern.RightHandPath.capturingZeroSegments);
            }
        }
        ,
        SUB_RESOURCE_LOCATOR{

            @Override
            PathPattern createPatternFor(String pathTemplate) {
                return new PathPattern(pathTemplate, PathPattern.RightHandPath.capturingZeroOrMoreSegments);
            }
        };


        abstract PathPattern createPatternFor(String var1);

        private static JaxrsType classify(String httpMethod) {
            if (httpMethod != null && !httpMethod.isEmpty()) {
                return RESOURCE_METHOD;
            }
            return SUB_RESOURCE_LOCATOR;
        }
    }
}

