/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.RuntimeExecutorsBinder;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.glassfish.jersey.servlet.ServletPropertiesDelegate;
import org.glassfish.jersey.servlet.WebAppResourcesScanner;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ResponseWriter;
import org.glassfish.jersey.servlet.internal.ServletContainerProviderFactory;
import org.glassfish.jersey.servlet.internal.spi.ServletContainerProvider;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;

public class WebComponent {
    private static final Logger LOGGER = Logger.getLogger(WebComponent.class.getName());
    private static final AsyncContextDelegate DefaultAsyncDELEGATE = new AsyncContextDelegate(){

        @Override
        public void suspend() throws IllegalStateException {
            throw new UnsupportedOperationException(LocalizationMessages.ASYNC_PROCESSING_NOT_SUPPORTED());
        }

        @Override
        public void complete() {
        }
    };
    final ApplicationHandler appHandler;
    final ScheduledExecutorService backgroundTaskScheduler;
    final WebConfig webConfig;
    final boolean forwardOn404;
    private final AsyncContextDelegateProvider asyncExtensionDelegate;

    private AsyncContextDelegateProvider getAsyncExtensionDelegate() {
        Iterator<AsyncContextDelegateProvider> providers = Providers.getAllProviders(this.appHandler.getServiceLocator(), AsyncContextDelegateProvider.class).iterator();
        if (providers.hasNext()) {
            return providers.next();
        }
        return new AsyncContextDelegateProvider(){

            @Override
            public AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
                return DefaultAsyncDELEGATE;
            }
        };
    }

    public WebComponent(WebConfig webConfig, ResourceConfig resourceConfig) throws ServletException {
        this.webConfig = webConfig;
        if (resourceConfig == null) {
            resourceConfig = WebComponent.createResourceConfig(webConfig);
        }
        WebComponent.configure(resourceConfig);
        resourceConfig.register((Object)new WebComponentBinder(resourceConfig.getProperties(), RuntimeType.SERVER));
        this.appHandler = new ApplicationHandler(resourceConfig);
        this.asyncExtensionDelegate = this.getAsyncExtensionDelegate();
        this.forwardOn404 = webConfig.getConfigType().equals((Object)WebConfig.ConfigType.FilterConfig) && resourceConfig.isProperty("jersey.config.servlet.filter.forwardOn404");
        this.backgroundTaskScheduler = (ScheduledExecutorService)this.appHandler.getServiceLocator().getService(ScheduledExecutorService.class, new Annotation[]{new RuntimeExecutorsBinder.BackgroundSchedulerLiteral()});
    }

    public Value<Integer> service(URI baseUri, URI requestUri, final HttpServletRequest servletRequest, final HttpServletResponse servletResponse) throws ServletException, IOException {
        ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, servletRequest.getMethod(), this.getSecurityContext(servletRequest), new ServletPropertiesDelegate(servletRequest));
        requestContext.setEntityStream((InputStream)servletRequest.getInputStream());
        this.addRequestHeaders(servletRequest, requestContext);
        this.filterFormParameters(servletRequest, requestContext);
        try {
            final ResponseWriter responseWriter = new ResponseWriter(this.forwardOn404, servletResponse, this.asyncExtensionDelegate.createDelegate(servletRequest, servletResponse), this.backgroundTaskScheduler);
            requestContext.setRequestScopedInitializer(new RequestScopedInitializer(){

                @Override
                public void initialize(ServiceLocator locator) {
                    ((Ref)locator.getService(new TypeLiteral<Ref<HttpServletRequest>>(){}.getType(), new Annotation[0])).set(servletRequest);
                    ((Ref)locator.getService(new TypeLiteral<Ref<HttpServletResponse>>(){}.getType(), new Annotation[0])).set(servletResponse);
                }
            });
            requestContext.setWriter(responseWriter);
            this.appHandler.handle(requestContext);
            return Values.lazy(new Value<Integer>(){

                @Override
                public Integer get() {
                    return responseWriter.getResponseStatus();
                }
            });
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private SecurityContext getSecurityContext(final HttpServletRequest request) {
        return new SecurityContext(){

            @Override
            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            @Override
            public boolean isUserInRole(String role) {
                return request.isUserInRole(role);
            }

            @Override
            public boolean isSecure() {
                return request.isSecure();
            }

            @Override
            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private static ResourceConfig createResourceConfig(WebConfig config) throws ServletException {
        Map<String, Object> initParams = WebComponent.getInitParams(config);
        Map<String, Object> contextParams = WebComponent.getContextParams(config.getServletContext());
        String jaxrsApplicationClassName = config.getInitParameter("javax.ws.rs.Application");
        if (jaxrsApplicationClassName == null) {
            ResourceConfig rc = new ResourceConfig().addProperties(initParams).addProperties(contextParams);
            String webApp = config.getInitParameter("jersey.config.servlet.provider.webapp");
            if (webApp != null && !"false".equals(webApp)) {
                rc.registerFinder(new WebAppResourcesScanner(config.getServletContext()));
            }
            return rc;
        }
        try {
            Class jaxrsApplicationClass = AccessController.doPrivileged(ReflectionHelper.classForNameWithExceptionPEA(jaxrsApplicationClassName));
            if (Application.class.isAssignableFrom(jaxrsApplicationClass)) {
                return ResourceConfig.forApplicationClass(jaxrsApplicationClass).addProperties(initParams).addProperties(contextParams);
            }
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_PARENT_CLASS_INVALID(jaxrsApplicationClassName, Application.class));
        }
        catch (PrivilegedActionException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), e.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), (Throwable)e);
        }
    }

    private static void configure(ResourceConfig resourceConfig) throws ServletException {
        ServletContainerProvider[] allServletContainerProviders;
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders = ServletContainerProviderFactory.getAllServletContainerProviders()) {
            servletContainerProvider.configure(resourceConfig);
        }
    }

    private void addRequestHeaders(HttpServletRequest request, ContainerRequest requestContext) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (value == null) continue;
                requestContext.header(name, value);
            }
        }
    }

    private static Map<String, Object> getInitParams(WebConfig webConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = webConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, webConfig.getInitParameter(name));
        }
        return props;
    }

    public static Map<String, Object> getContextParams(ServletContext servletContext) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = servletContext.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, servletContext.getAttribute(name));
        }
        return props;
    }

    private void filterFormParameters(HttpServletRequest hsr, ContainerRequest request) throws IOException {
        if (MediaTypes.typeEqual(MediaType.APPLICATION_FORM_URLENCODED_TYPE, request.getMediaType()) && !request.hasEntity()) {
            Form f = new Form();
            Enumeration e = hsr.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = hsr.getParameterValues(name);
                f.asMap().put(name, (String)((Object)Arrays.asList(values)));
            }
            if (!f.asMap().isEmpty()) {
                request.setProperty("jersey.config.server.representation.decoded.form", f);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.FORM_PARAM_CONSUMED(request.getRequestUri()));
                }
            }
        }
    }

    private class WebComponentBinder
    extends AbstractBinder {
        private final Map<String, Object> applicationProperties;
        private final RuntimeType runtimeType;

        private WebComponentBinder(Map<String, Object> applicationProperties, RuntimeType runtimeType) {
            this.applicationProperties = applicationProperties;
            this.runtimeType = runtimeType;
        }

        /*
         * Exception decompiling
         */
        protected void configure() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class HttpServletResponseReferencingFactory
    extends ReferencingFactory<HttpServletResponse> {
        @Inject
        public HttpServletResponseReferencingFactory(Provider<Ref<HttpServletResponse>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class HttpServletRequestReferencingFactory
    extends ReferencingFactory<HttpServletRequest> {
        @Inject
        public HttpServletRequestReferencingFactory(Provider<Ref<HttpServletRequest>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

