/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.process;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.inject.ReferenceTransformingFactory;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestExecutorFactory;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.internal.process.ReferencesInitializer;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.process.SecurityContextInjectee;
import org.glassfish.jersey.server.internal.process.ServerManagedAsyncExecutorFactory;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public class ServerProcessingBinder
extends AbstractBinder {
    protected void configure() {
        this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<RequestProcessingContext>>(){}).proxy(false).in(RequestScoped.class);
        this.bindFactory(ContainerRequestFactory.class).to(ContainerRequest.class).to(ContainerRequestContext.class).proxy(false).in(RequestScoped.class);
        this.bindFactory(ContainerRequestFactory.class).to(HttpHeaders.class).to(Request.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(UriRoutingContextFactory.class).to(UriInfo.class).to(ExtendedUriInfo.class).to(ResourceInfo.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bind(SecurityContextInjectee.class).to(SecurityContext.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(CloseableServiceFactory.class).to(CloseableService.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(AsyncContextFactory.class).to(AsyncContext.class).to(AsyncResponse.class).in(RequestScoped.class);
        this.bind(ServerManagedAsyncExecutorFactory.class).to(RequestExecutorFactory.class).to(ContainerLifecycleListener.class).in(Singleton.class);
        this.bindAsContract(ReferencesInitializer.class);
    }

    private static class AsyncContextFactory
    extends ReferenceTransformingFactory<RequestProcessingContext, AsyncContext> {
        @Inject
        protected AsyncContextFactory(Provider<Ref<RequestProcessingContext>> refProvider) {
            super(refProvider, new ReferenceTransformingFactory.Transformer<RequestProcessingContext, AsyncContext>(){

                @Override
                public AsyncContext transform(RequestProcessingContext value) {
                    return value.asyncContext();
                }
            });
        }

        @Override
        @RequestScoped
        public AsyncContext provide() {
            return (AsyncContext)super.provide();
        }
    }

    private static class CloseableServiceFactory
    extends ReferenceTransformingFactory<RequestProcessingContext, CloseableService> {
        @Inject
        protected CloseableServiceFactory(Provider<Ref<RequestProcessingContext>> refProvider) {
            super(refProvider, new ReferenceTransformingFactory.Transformer<RequestProcessingContext, CloseableService>(){

                @Override
                public CloseableService transform(RequestProcessingContext value) {
                    return value.closeableService();
                }
            });
        }

        @Override
        @RequestScoped
        public CloseableService provide() {
            return (CloseableService)super.provide();
        }
    }

    private static class UriRoutingContextFactory
    extends ReferenceTransformingFactory<RequestProcessingContext, UriRoutingContext> {
        @Inject
        protected UriRoutingContextFactory(Provider<Ref<RequestProcessingContext>> refProvider) {
            super(refProvider, new ReferenceTransformingFactory.Transformer<RequestProcessingContext, UriRoutingContext>(){

                @Override
                public UriRoutingContext transform(RequestProcessingContext value) {
                    return value.uriRoutingContext();
                }
            });
        }

        @Override
        @RequestScoped
        public UriRoutingContext provide() {
            return (UriRoutingContext)super.provide();
        }
    }

    private static class ContainerRequestFactory
    extends ReferenceTransformingFactory<RequestProcessingContext, ContainerRequest> {
        @Inject
        protected ContainerRequestFactory(Provider<Ref<RequestProcessingContext>> refProvider) {
            super(refProvider, new ReferenceTransformingFactory.Transformer<RequestProcessingContext, ContainerRequest>(){

                @Override
                public ContainerRequest transform(RequestProcessingContext value) {
                    return value.request();
                }
            });
        }

        @Override
        @RequestScoped
        public ContainerRequest provide() {
            return (ContainerRequest)super.provide();
        }
    }
}

