/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.MethodAcceptorPair;
import org.glassfish.jersey.server.internal.routing.MethodSelectingRouter;
import org.glassfish.jersey.server.internal.routing.PathPatternRouteBuilder;
import org.glassfish.jersey.server.internal.routing.PushMatchedMethodRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedRuntimeResourceRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedTemplateRouter;
import org.glassfish.jersey.server.internal.routing.PushMatchedUriRouter;
import org.glassfish.jersey.server.internal.routing.PushMethodHandlerRouter;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.Routers;
import org.glassfish.jersey.server.internal.routing.SubResourceLocatorRouter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.server.model.RuntimeResourceModel;
import org.glassfish.jersey.uri.PathPattern;
import org.glassfish.jersey.uri.UriTemplate;

public final class RuntimeModelBuilder {
    private final Routers.RootRouteBuilder<PathPattern> rootBuilder;
    private final ResourceMethodInvoker.Builder resourceMethodInvokerBuilder;
    private final ServiceLocator locator;
    private final MessageBodyWorkers workers;
    private ProcessingProviders processingProviders;

    @Inject
    public RuntimeModelBuilder(ResourceMethodInvoker.Builder resourceMethodInvokerBuilder, ServiceLocator locator, MessageBodyWorkers workers) {
        this.resourceMethodInvokerBuilder = resourceMethodInvokerBuilder;
        this.locator = locator;
        this.workers = workers;
        this.rootBuilder = new PathPatternRouteBuilder(locator);
    }

    private Router createMethodAcceptor(ResourceMethod resourceMethod) {
        Router methodAcceptor = null;
        switch (resourceMethod.getType()) {
            case RESOURCE_METHOD: 
            case SUB_RESOURCE_METHOD: {
                methodAcceptor = Routers.asTreeAcceptor(this.createInflector(resourceMethod));
                break;
            }
            case SUB_RESOURCE_LOCATOR: {
                methodAcceptor = new SubResourceLocatorRouter(this.locator, this, resourceMethod);
            }
        }
        return new PushMethodHandlerRouter(resourceMethod.getInvocable().getHandler(), methodAcceptor);
    }

    private Inflector<RequestProcessingContext, ContainerResponse> createInflector(ResourceMethod method) {
        return this.resourceMethodInvokerBuilder.build(method, this.processingProviders);
    }

    private Router createRootTreeAcceptor(Routers.RouteToPathBuilder<PathPattern> lastRoutedBuilder, boolean subResourceMode) {
        Router routingRoot = lastRoutedBuilder != null ? lastRoutedBuilder.build() : Routers.acceptingTree(new Function<RequestProcessingContext, RequestProcessingContext>(){

            public RequestProcessingContext apply(RequestProcessingContext input) {
                return input;
            }
        }).build();
        if (subResourceMode) {
            return routingRoot;
        }
        return this.rootBuilder.root(routingRoot);
    }

    private Routers.RouteToPathBuilder<PathPattern> routeMethodAcceptor(Routers.RouteToPathBuilder<PathPattern> lastRoutedBuilder, PathPattern pathPattern, PushMatchedUriRouter uriPushingAcceptor, PushMatchedRuntimeResourceRouter resourcePushingRouter, Router methodAcceptor, boolean subResourceMode) {
        if (subResourceMode) {
            return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(resourcePushingRouter).to(methodAcceptor);
        }
        return this.routedBuilder(lastRoutedBuilder).route(pathPattern).to(uriPushingAcceptor).to(resourcePushingRouter).to(methodAcceptor);
    }

    public Router buildModel(RuntimeResourceModel resourceModel, boolean subResourceMode) {
        List<RuntimeResource> runtimeResources = resourceModel.getRuntimeResources();
        PushMatchedUriRouter uriPushingRouter = new PushMatchedUriRouter();
        Routers.RouteToPathBuilder<PathPattern> lastRoutedBuilder = null;
        for (RuntimeResource resource : runtimeResources) {
            PushMatchedRuntimeResourceRouter resourcePushingRouter = new PushMatchedRuntimeResourceRouter(resource);
            if (!resource.getResourceMethods().isEmpty()) {
                List<MethodAcceptorPair> methodAcceptors = this.createAcceptors(resource, subResourceMode);
                PathPattern resourceClosedPattern = subResourceMode ? PathPattern.END_OF_PATH_PATTERN : PathPattern.asClosed(resource.getPathPattern());
                lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, resourceClosedPattern, uriPushingRouter, resourcePushingRouter, new MethodSelectingRouter(this.workers, methodAcceptors), subResourceMode);
            }
            Routers.RouteToPathBuilder<PathPattern> srRoutedBuilder = null;
            if (!resource.getChildRuntimeResources().isEmpty()) {
                for (RuntimeResource child : resource.getChildRuntimeResources()) {
                    PathPattern childOpenPattern = child.getPathPattern();
                    PathPattern childClosedPattern = PathPattern.asClosed(childOpenPattern);
                    PushMatchedRuntimeResourceRouter childResourcePushingRouter = new PushMatchedRuntimeResourceRouter(child);
                    if (!child.getResourceMethods().isEmpty()) {
                        List<MethodAcceptorPair> childMethodAcceptors = this.createAcceptors(child, subResourceMode);
                        srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(childClosedPattern).to(uriPushingRouter).to(childResourcePushingRouter).to(new MethodSelectingRouter(this.workers, childMethodAcceptors));
                    }
                    if (child.getResourceLocator() == null) continue;
                    PushMatchedTemplateRouter locTemplateRouter = this.getTemplateRouterForChildLocator(subResourceMode, child);
                    srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(childOpenPattern).to(uriPushingRouter).to(locTemplateRouter).to(childResourcePushingRouter).to(new PushMatchedMethodRouter(child.getResourceLocator())).to(this.createMethodAcceptor(child.getResourceLocator()));
                }
            }
            if (resource.getResourceLocator() != null) {
                PushMatchedTemplateRouter resourceTemplateRouter = this.getTemplateRouter(subResourceMode, this.getLocatorResource(resource).getPathPattern().getTemplate(), PathPattern.OPEN_ROOT_PATH_PATTERN.getTemplate());
                srRoutedBuilder = this.routedBuilder(srRoutedBuilder).route(PathPattern.OPEN_ROOT_PATH_PATTERN).to(uriPushingRouter).to(resourceTemplateRouter).to(new PushMatchedMethodRouter(resource.getResourceLocator())).to(this.createMethodAcceptor(resource.getResourceLocator()));
            }
            if (srRoutedBuilder == null) continue;
            PathPattern resourceOpenPattern = subResourceMode ? PathPattern.OPEN_ROOT_PATH_PATTERN : resource.getPathPattern();
            lastRoutedBuilder = this.routeMethodAcceptor(lastRoutedBuilder, resourceOpenPattern, uriPushingRouter, resourcePushingRouter, srRoutedBuilder.build(), subResourceMode);
        }
        return this.createRootTreeAcceptor(lastRoutedBuilder, subResourceMode);
    }

    private PushMatchedTemplateRouter getTemplateRouterForChildLocator(boolean subResourceMode, RuntimeResource child) {
        int i = 0;
        for (Resource res : child.getResources()) {
            if (res.getResourceLocator() != null) {
                return this.getTemplateRouter(subResourceMode, child.getParentResources().get(i).getPathPattern().getTemplate(), res.getPathPattern().getTemplate());
            }
            ++i;
        }
        return null;
    }

    private PushMatchedTemplateRouter getTemplateRouter(boolean subResourceMode, UriTemplate parentTemplate, UriTemplate childTemplate) {
        if (childTemplate != null) {
            return new PushMatchedTemplateRouter(subResourceMode ? PathPattern.OPEN_ROOT_PATH_PATTERN.getTemplate() : parentTemplate, childTemplate);
        }
        return new PushMatchedTemplateRouter(subResourceMode ? PathPattern.END_OF_PATH_PATTERN.getTemplate() : parentTemplate);
    }

    private Resource getLocatorResource(RuntimeResource resource) {
        for (Resource res : resource.getResources()) {
            if (res.getResourceLocator() == null) continue;
            return res;
        }
        return null;
    }

    private List<MethodAcceptorPair> createAcceptors(RuntimeResource runtimeResource, boolean subResourceMode) {
        ArrayList acceptorPairList = Lists.newArrayList();
        int i = 0;
        for (Resource resource : runtimeResource.getResources()) {
            Resource parentResource = runtimeResource.getParent() == null ? null : runtimeResource.getParentResources().get(i++);
            UriTemplate template = resource.getPathPattern().getTemplate();
            PushMatchedTemplateRouter templateRouter = parentResource == null ? this.getTemplateRouter(subResourceMode, template, null) : this.getTemplateRouter(subResourceMode, parentResource.getPathPattern().getTemplate(), template);
            for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
                acceptorPairList.add(new MethodAcceptorPair(resourceMethod, templateRouter, new PushMatchedMethodRouter(resourceMethod), this.createMethodAcceptor(resourceMethod)));
            }
        }
        return acceptorPairList;
    }

    private Routers.RouteBuilder<PathPattern> routedBuilder(Routers.RouteToPathBuilder<PathPattern> lastRoutedBuilder) {
        return lastRoutedBuilder == null ? this.rootBuilder : lastRoutedBuilder;
    }

    public void setProcessingProviders(ProcessingProviders processingProviders) {
        this.processingProviders = processingProviders;
    }
}

