/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.List;
import java.util.regex.MatchResult;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.Route;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.uri.PathPattern;

class PathPatternRouter
implements Router {
    private final Provider<RoutingContext> contextProvider;
    private final List<Route<PathPattern>> acceptedRoutes;

    private PathPatternRouter(Provider<RoutingContext> provider, List<Route<PathPattern>> routes) {
        this.contextProvider = provider;
        this.acceptedRoutes = routes;
    }

    @Override
    public Router.Continuation apply(ContainerRequest request) {
        RoutingContext rc = (RoutingContext)this.contextProvider.get();
        String path = rc.getFinalMatchingGroup();
        for (Route<PathPattern> acceptedRoute : this.acceptedRoutes) {
            MatchResult m = acceptedRoute.routingPattern().match(path);
            if (m == null) continue;
            rc.pushMatchResult(m);
            return Router.Continuation.of(request, acceptedRoute.next());
        }
        return Router.Continuation.of(request);
    }

    public static class Builder {
        @Inject
        private Provider<RoutingContext> contextProvider;

        public PathPatternRouter build(List<Route<PathPattern>> routes) {
            return new PathPatternRouter(this.contextProvider, routes);
        }
    }
}

