/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.Inflecting;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.internal.routing.TransformableData;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class RoutingStage
extends AbstractChainableStage<ContainerRequest> {
    private final Router routingRoot;
    private final Provider<RoutingContext> routingContextFactory;

    private RoutingStage(Router routingRoot, Provider<RoutingContext> routingContextFactory) {
        this.routingRoot = routingRoot;
        this.routingContextFactory = routingContextFactory;
    }

    @Override
    public Stage.Continuation<ContainerRequest> apply(ContainerRequest request) {
        request.triggerEvent(RequestEvent.Type.MATCHING_START);
        TransformableData<ContainerRequest, ContainerResponse> result = this._apply(request, this.routingRoot);
        Stage nextStage = null;
        if (result.hasInflector()) {
            ((RoutingContext)this.routingContextFactory.get()).setInflector(result.inflector());
            nextStage = this.getDefaultNext();
        }
        return Stage.Continuation.of(result.data(), nextStage);
    }

    private TransformableData<ContainerRequest, ContainerResponse> _apply(ContainerRequest request, Router router) {
        Router.Continuation continuation = router.apply(request);
        for (Router child : continuation.next()) {
            TransformableData<ContainerRequest, ContainerResponse> result = this._apply(continuation.requestContext(), child);
            if (!result.hasInflector()) continue;
            return result;
        }
        if (router instanceof Inflecting) {
            return TransformableData.of(continuation.requestContext(), ((Inflecting)((Object)router)).inflector());
        }
        return TransformableData.of(continuation.requestContext());
    }

    public static class Builder {
        @Inject
        private Provider<RoutingContext> routingContextFactory;

        public RoutingStage build(Router routingRoot) {
            return new RoutingStage(routingRoot, this.routingContextFactory);
        }
    }
}

