/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.jersey.internal.util.collection.ImmutableMultivaluedMap;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceMethodInvoker;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.uri.UriComponent;
import org.glassfish.jersey.uri.UriTemplate;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;

@RequestScoped
public class UriRoutingContext
implements RoutingContext,
ExtendedUriInfo {
    private final LinkedList<MatchResult> matchResults = Lists.newLinkedList();
    private final LinkedList<Object> matchedResources = Lists.newLinkedList();
    private final LinkedList<UriTemplate> templates = Lists.newLinkedList();
    private MultivaluedHashMap<String, String> encodedTemplateValues;
    private ImmutableMultivaluedMap<String, String> encodedTemplateValuesView;
    private MultivaluedHashMap<String, String> decodedTemplateValues;
    private ImmutableMultivaluedMap<String, String> decodedTemplateValuesView;
    private ImmutableMultivaluedMap<String, String> encodedQueryParamsView;
    private ImmutableMultivaluedMap<String, String> decodedQueryParamsView;
    private final LinkedList<String> paths = Lists.newLinkedList();
    private Inflector<ContainerRequest, ContainerResponse> inflector;
    private final LinkedList<RuntimeResource> matchedRuntimeResources = Lists.newLinkedList();
    private volatile ResourceMethod matchedResourceMethod = null;
    private final ProcessingProviders processingProviders;
    private final LinkedList<ResourceMethod> matchedLocators = Lists.newLinkedList();
    private final LinkedList<Resource> locatorSubResources = Lists.newLinkedList();
    private Ref<ContainerRequest> requestContext;

    @Inject
    UriRoutingContext(Ref<ContainerRequest> requestContext, ProcessingProviders processingProviders) {
        this.requestContext = requestContext;
        this.processingProviders = processingProviders;
    }

    @Override
    public void pushMatchResult(MatchResult matchResult) {
        this.matchResults.push(matchResult);
    }

    @Override
    public void pushMatchedResource(Object resource) {
        this.matchedResources.push(resource);
    }

    @Override
    public Object peekMatchedResource() {
        return this.matchedResources.peek();
    }

    @Override
    public void pushMatchedLocator(ResourceMethod resourceLocator) {
        this.matchedLocators.push(resourceLocator);
    }

    @Override
    public void pushLeftHandPath() {
        String rightHandPath = this.getFinalMatchingGroup();
        int rhpLength = rightHandPath != null ? rightHandPath.length() : 0;
        String encodedRequestPath = this.getAbsolutePath().toString();
        if (encodedRequestPath.length() != rhpLength) {
            int startIndex = encodedRequestPath.length() > 1 && encodedRequestPath.charAt(0) == '/' ? 1 : 0;
            this.paths.addFirst(encodedRequestPath.substring(startIndex, encodedRequestPath.length() - rhpLength));
        }
    }

    @Override
    public void pushTemplates(UriTemplate resourceTemplate, UriTemplate methodTemplate) {
        if (this.encodedTemplateValues == null) {
            this.encodedTemplateValues = new MultivaluedHashMap();
        }
        Iterator matchResultIterator = this.matchResults.iterator();
        this.templates.push(resourceTemplate);
        if (methodTemplate != null) {
            this.templates.push(methodTemplate);
            matchResultIterator.next();
        }
        this.pushMatchedTemplateValues(resourceTemplate, (MatchResult)matchResultIterator.next());
        if (methodTemplate != null) {
            this.pushMatchedTemplateValues(methodTemplate, this.matchResults.peek());
        }
    }

    private void pushMatchedTemplateValues(UriTemplate template, MatchResult matchResult) {
        int i = 1;
        for (String templateVariable : template.getTemplateVariables()) {
            String value = matchResult.group(i++);
            this.encodedTemplateValues.addFirst(templateVariable, value);
            if (this.decodedTemplateValues == null) continue;
            this.decodedTemplateValues.addFirst(UriComponent.decode(templateVariable, UriComponent.Type.PATH_SEGMENT), UriComponent.decode(value, UriComponent.Type.PATH));
        }
    }

    @Override
    public MatchResult peekMatchResult() {
        return this.matchResults.peek();
    }

    @Override
    public String getFinalMatchingGroup() {
        MatchResult mr = this.matchResults.peek();
        if (mr == null) {
            return null;
        }
        String finalGroup = mr.group(mr.groupCount());
        return finalGroup == null ? "" : finalGroup;
    }

    public LinkedList<MatchResult> getMatchedResults() {
        return this.matchResults;
    }

    @Override
    public void setInflector(Inflector<ContainerRequest, ContainerResponse> inflector) {
        this.inflector = inflector;
    }

    @Override
    public Inflector<ContainerRequest, ContainerResponse> getInflector() {
        return this.inflector;
    }

    @Override
    public Iterable<RankedProvider<ContainerRequestFilter>> getBoundRequestFilters() {
        return UriRoutingContext.emptyIfNull(this.inflector instanceof ResourceMethodInvoker ? ((ResourceMethodInvoker)this.inflector).getRequestFilters() : null);
    }

    @Override
    public Iterable<RankedProvider<ContainerResponseFilter>> getBoundResponseFilters() {
        return UriRoutingContext.emptyIfNull(this.inflector instanceof ResourceMethodInvoker ? ((ResourceMethodInvoker)this.inflector).getResponseFilters() : null);
    }

    @Override
    public Iterable<ReaderInterceptor> getBoundReaderInterceptors() {
        return this.inflector instanceof ResourceMethodInvoker ? ((ResourceMethodInvoker)this.inflector).getReaderInterceptors() : this.processingProviders.getSortedGlobalReaderInterceptors();
    }

    @Override
    public Iterable<WriterInterceptor> getBoundWriterInterceptors() {
        return this.inflector instanceof ResourceMethodInvoker ? ((ResourceMethodInvoker)this.inflector).getWriterInterceptors() : this.processingProviders.getSortedGlobalWriterInterceptors();
    }

    @Override
    public void setMatchedResourceMethod(ResourceMethod resourceMethod) {
        this.matchedResourceMethod = resourceMethod;
    }

    @Override
    public void pushMatchedRuntimeResource(RuntimeResource runtimeResource) {
        this.matchedRuntimeResources.push(runtimeResource);
    }

    @Override
    public void pushLocatorSubResource(Resource subResourceFromLocator) {
        this.locatorSubResources.push(subResourceFromLocator);
    }

    private static <T> Iterable<T> emptyIfNull(Iterable<T> iterable) {
        return iterable == null ? Collections.emptyList() : iterable;
    }

    @Override
    public URI getAbsolutePath() {
        return URI.create(this.getEncodedPath());
    }

    @Override
    public UriBuilder getAbsolutePathBuilder() {
        return new JerseyUriBuilder().uri(this.getAbsolutePath());
    }

    @Override
    public URI getBaseUri() {
        return ((ContainerRequest)this.requestContext.get()).getBaseUri();
    }

    @Override
    public UriBuilder getBaseUriBuilder() {
        return new JerseyUriBuilder().uri(this.getBaseUri());
    }

    @Override
    public List<Object> getMatchedResources() {
        return Collections.unmodifiableList(this.matchedResources);
    }

    @Override
    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    @Override
    public List<String> getMatchedURIs(boolean decode) {
        List<String> result = decode ? Lists.transform(this.paths, (Function)new Function<String, String>(){

            public String apply(String input) {
                return UriComponent.decode(input, UriComponent.Type.PATH);
            }
        }) : this.paths;
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getPath() {
        return ((ContainerRequest)this.requestContext.get()).getPath(true);
    }

    @Override
    public String getPath(boolean decode) {
        return ((ContainerRequest)this.requestContext.get()).getPath(decode);
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    @Override
    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (decode) {
            if (this.decodedTemplateValuesView != null) {
                return this.decodedTemplateValuesView;
            }
            if (this.decodedTemplateValues == null) {
                this.decodedTemplateValues = new MultivaluedHashMap();
                for (Map.Entry e : this.encodedTemplateValues.entrySet()) {
                    this.decodedTemplateValues.put(UriComponent.decode((String)e.getKey(), UriComponent.Type.PATH_SEGMENT), new LinkedList(Lists.transform(e.getValue(), (Function)new Function<String, String>(){

                        public String apply(String input) {
                            return UriComponent.decode(input, UriComponent.Type.PATH);
                        }
                    })));
                }
            }
            this.decodedTemplateValuesView = new ImmutableMultivaluedMap<String, String>(this.decodedTemplateValues);
            return this.decodedTemplateValuesView;
        }
        if (this.encodedTemplateValuesView != null) {
            return this.encodedTemplateValuesView;
        }
        if (this.encodedTemplateValues == null) {
            this.encodedTemplateValues = new MultivaluedHashMap();
        }
        this.encodedTemplateValuesView = new ImmutableMultivaluedMap<String, String>(this.encodedTemplateValues);
        return this.encodedTemplateValuesView;
    }

    private String getEncodedPath() {
        URI requestUri = this.getRequestUri();
        String rp = requestUri.toString();
        String qrp = requestUri.getRawQuery();
        return qrp == null ? rp : rp.substring(0, rp.length() - qrp.length() - 1);
    }

    @Override
    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    @Override
    public List<PathSegment> getPathSegments(boolean decode) {
        String ep = this.getEncodedPath();
        String base = this.getBaseUri().toString();
        return Collections.unmodifiableList(UriComponent.decodePath(ep.substring(base.length()), decode));
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(false);
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            if (this.decodedQueryParamsView != null) {
                return this.decodedQueryParamsView;
            }
            this.decodedQueryParamsView = new ImmutableMultivaluedMap<String, String>(UriComponent.decodeQuery(this.getRequestUri(), true));
            return this.decodedQueryParamsView;
        }
        if (this.encodedQueryParamsView != null) {
            return this.encodedQueryParamsView;
        }
        this.encodedQueryParamsView = new ImmutableMultivaluedMap<String, String>(UriComponent.decodeQuery(this.getRequestUri(), false));
        return this.encodedQueryParamsView;
    }

    @Override
    public URI getRequestUri() {
        return ((ContainerRequest)this.requestContext.get()).getRequestUri();
    }

    @Override
    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri(this.getRequestUri());
    }

    @Override
    public Throwable getMappedThrowable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<UriTemplate> getMatchedTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    @Override
    public List<PathSegment> getPathSegments(String name) {
        return this.getPathSegments(name, true);
    }

    @Override
    public List<PathSegment> getPathSegments(String name, boolean decode) {
        int[] bounds = this.getPathParameterBounds(name);
        if (bounds != null) {
            String path = this.matchResults.getLast().group();
            int segmentsStart = 0;
            for (int x = 0; x < bounds[0]; ++x) {
                if (path.charAt(x) != '/') continue;
                ++segmentsStart;
            }
            int segmentsEnd = segmentsStart;
            for (int x = bounds[0]; x < bounds[1]; ++x) {
                if (path.charAt(x) != '/') continue;
                ++segmentsEnd;
            }
            return this.getPathSegments(decode).subList(segmentsStart - 1, segmentsEnd);
        }
        return Collections.emptyList();
    }

    private int[] getPathParameterBounds(String name) {
        Iterator templatesIterator = this.templates.iterator();
        Iterator matchResultsIterator = this.matchResults.iterator();
        while (templatesIterator.hasNext()) {
            MatchResult mr = (MatchResult)matchResultsIterator.next();
            int pIndex = this.getLastPathParameterIndex(name, (UriTemplate)templatesIterator.next());
            if (pIndex == -1) continue;
            int pathLength = mr.group().length();
            int segmentIndex = mr.end(pIndex + 1);
            int groupLength = segmentIndex - mr.start(pIndex + 1);
            while (matchResultsIterator.hasNext()) {
                mr = (MatchResult)matchResultsIterator.next();
                segmentIndex += mr.group().length() - pathLength;
                pathLength = mr.group().length();
            }
            return new int[]{segmentIndex - groupLength, segmentIndex};
        }
        return null;
    }

    private int getLastPathParameterIndex(String name, UriTemplate t) {
        int i = 0;
        int pIndex = -1;
        for (String parameterName : t.getTemplateVariables()) {
            if (parameterName.equals(name)) {
                pIndex = i;
            }
            ++i;
        }
        return pIndex;
    }

    @Override
    public Method getResourceMethod() {
        return this.inflector instanceof ResourceMethodInvoker ? ((ResourceMethodInvoker)this.inflector).getResourceMethod() : null;
    }

    @Override
    public Class<?> getResourceClass() {
        return this.inflector instanceof ResourceMethodInvoker ? ((ResourceMethodInvoker)this.inflector).getResourceClass() : null;
    }

    @Override
    public List<RuntimeResource> getMatchedRuntimeResources() {
        return this.matchedRuntimeResources;
    }

    @Override
    public ResourceMethod getMatchedResourceMethod() {
        return this.matchedResourceMethod;
    }

    @Override
    public List<ResourceMethod> getMatchedResourceLocators() {
        return this.matchedLocators;
    }

    @Override
    public List<Resource> getLocatorSubResources() {
        return this.locatorSubResources;
    }

    @Override
    public Resource getMatchedModelResource() {
        return this.matchedResourceMethod == null ? null : this.matchedResourceMethod.getParent();
    }

    @Override
    public URI resolve(URI uri) {
        return UriTemplate.resolve(this.getBaseUri(), uri);
    }

    @Override
    public URI relativize(URI uri) {
        if (!uri.isAbsolute()) {
            uri = this.resolve(uri);
        }
        return UriTemplate.relativize(this.getRequestUri(), uri);
    }
}

