/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Registration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.servlet.WebComponent;
import org.glassfish.jersey.servlet.init.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ServletContainerProviderFactory;
import org.glassfish.jersey.servlet.internal.spi.ServletContainerProvider;

@HandlesTypes(value={Path.class, Provider.class, Application.class, ApplicationPath.class})
public class JerseyServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(JerseyServletContainerInitializer.class.getName());

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        ServletContainerProvider[] allServletContainerProviders;
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders = ServletContainerProviderFactory.getAllServletContainerProviders()) {
            servletContainerProvider.init(servletContext);
        }
        String[] servletNames = this.onStartupImpl(classes, servletContext);
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.onRegister(servletContext, servletNames);
        }
    }

    private String[] onStartupImpl(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        HashSet<String> servletNames = new HashSet<String>();
        if (classes == null) {
            classes = Collections.emptySet();
        }
        for (Class<? extends Application> applicationClass : this.getApplicationClasses(classes)) {
            ServletRegistration servletRegistration = servletContext.getServletRegistration(applicationClass.getName());
            if (servletRegistration != null) {
                JerseyServletContainerInitializer.addNotNull(servletNames, this.addServletWithExistingRegistration(servletContext, servletRegistration, applicationClass, classes));
                continue;
            }
            List<Registration> srs = this.getInitParamDeclaredRegistrations(servletContext, applicationClass);
            if (!srs.isEmpty()) {
                for (Registration sr : srs) {
                    if (!(sr instanceof ServletRegistration)) continue;
                    JerseyServletContainerInitializer.addNotNull(servletNames, this.addServletWithExistingRegistration(servletContext, (ServletRegistration)sr, applicationClass, classes));
                }
                continue;
            }
            JerseyServletContainerInitializer.addNotNull(servletNames, this.addServletWithApplication(servletContext, applicationClass, classes));
        }
        JerseyServletContainerInitializer.addNotNull(servletNames, this.addServletWithDefaultConfiguration(servletContext, classes));
        JerseyServletContainerInitializer.collectJerseyServletNames(servletContext, servletNames);
        return servletNames.toArray(new String[servletNames.size()]);
    }

    private static void collectJerseyServletNames(ServletContext servletContext, Set<String> servletNames) {
        for (ServletRegistration servletRegistration : servletContext.getServletRegistrations().values()) {
            if (!JerseyServletContainerInitializer.isJerseyServlet(servletRegistration.getClassName())) continue;
            servletNames.add(servletRegistration.getName());
        }
    }

    private static boolean isJerseyServlet(String className) {
        return ServletContainer.class.getName().equals(className) || "org.glassfish.jersey.servlet.portability.PortableServletContainer".equals(className);
    }

    private List<Registration> getInitParamDeclaredRegistrations(ServletContext sc, Class<? extends Application> a) {
        ArrayList srs = Lists.newArrayList();
        this.collectJaxRsRegistrations(sc.getServletRegistrations(), srs, a);
        this.collectJaxRsRegistrations(sc.getFilterRegistrations(), srs, a);
        return srs;
    }

    private void collectJaxRsRegistrations(Map<String, ? extends Registration> registrations, List<Registration> collected, Class<? extends Application> a) {
        for (Registration registration : registrations.values()) {
            Map ips = registration.getInitParameters();
            if (!ips.containsKey("javax.ws.rs.Application") || !((String)ips.get("javax.ws.rs.Application")).equals(a.getName())) continue;
            collected.add(registration);
        }
    }

    private String addServletWithDefaultConfiguration(ServletContext sc, Set<Class<?>> classes) throws ServletException {
        String servletName = null;
        ServletRegistration appReg = sc.getServletRegistration(Application.class.getName());
        if (appReg != null && appReg.getClassName() == null) {
            Set<Class<?>> appClasses = this.getRootResourceAndProviderClasses(classes);
            ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(ResourceConfig.class, appClasses).addProperties(JerseyServletContainerInitializer.getInitParams(appReg)).addProperties(WebComponent.getContextParams(sc));
            ServletContainer s = new ServletContainer(resourceConfig);
            servletName = appReg.getName();
            appReg = sc.addServlet(servletName, (Servlet)s);
            ((ServletRegistration.Dynamic)appReg).setLoadOnStartup(1);
            if (appReg.getMappings().isEmpty()) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.JERSEY_APP_NO_MAPPING(appReg.getName()));
            } else {
                LOGGER.log(Level.INFO, LocalizationMessages.JERSEY_APP_REGISTERED_CLASSES(appReg.getName(), appClasses));
            }
        }
        return servletName;
    }

    private String addServletWithApplication(ServletContext sc, Class<? extends Application> a, Set<Class<?>> classes) throws ServletException {
        String servletName = null;
        ApplicationPath ap = a.getAnnotation(ApplicationPath.class);
        if (ap != null) {
            ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(a, classes);
            ServletContainer s = new ServletContainer(resourceConfig);
            servletName = a.getName();
            ServletRegistration.Dynamic dsr = sc.addServlet(servletName, (Servlet)s);
            dsr.setAsyncSupported(true);
            dsr.setLoadOnStartup(1);
            String mapping = this.createMappingPath(ap);
            if (!this.mappingExists(sc, mapping)) {
                dsr.addMapping(new String[]{mapping});
                LOGGER.log(Level.INFO, LocalizationMessages.JERSEY_APP_REGISTERED_MAPPING(a.getName(), mapping));
            } else {
                LOGGER.log(Level.SEVERE, LocalizationMessages.JERSEY_APP_MAPPING_CONFLICT(a.getName(), mapping));
            }
        }
        return servletName;
    }

    private String addServletWithExistingRegistration(ServletContext sc, ServletRegistration sr, Class<? extends Application> a, Set<Class<?>> classes) throws ServletException {
        String servletName = null;
        if (sr.getClassName() == null) {
            ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(a, classes).addProperties(JerseyServletContainerInitializer.getInitParams(sr)).addProperties(WebComponent.getContextParams(sc));
            ServletContainer s = new ServletContainer(resourceConfig);
            servletName = a.getName();
            ServletRegistration.Dynamic dsr = sc.addServlet(servletName, (Servlet)s);
            dsr.setAsyncSupported(true);
            dsr.setLoadOnStartup(1);
            if (dsr.getMappings().isEmpty()) {
                ApplicationPath ap = a.getAnnotation(ApplicationPath.class);
                if (ap != null) {
                    String mapping = this.createMappingPath(ap);
                    if (!this.mappingExists(sc, mapping)) {
                        dsr.addMapping(new String[]{mapping});
                        LOGGER.log(Level.INFO, LocalizationMessages.JERSEY_APP_REGISTERED_MAPPING(a.getName(), mapping));
                    } else {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.JERSEY_APP_MAPPING_CONFLICT(a.getName(), mapping));
                    }
                } else {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.JERSEY_APP_NO_MAPPING_OR_ANNOTATION(a.getName(), ApplicationPath.class.getSimpleName()));
                }
            } else {
                LOGGER.log(Level.INFO, LocalizationMessages.JERSEY_APP_REGISTERED_APPLICATION(a.getName()));
            }
        }
        return servletName;
    }

    private static void addNotNull(Set<String> list, String value) {
        if (value != null) {
            list.add(value);
        }
    }

    private static Map<String, Object> getInitParams(ServletRegistration sr) {
        HashMap initParams = Maps.newHashMap();
        for (Map.Entry entry : sr.getInitParameters().entrySet()) {
            initParams.put(entry.getKey(), entry.getValue());
        }
        return initParams;
    }

    private boolean mappingExists(ServletContext sc, String mapping) {
        for (ServletRegistration sr : sc.getServletRegistrations().values()) {
            for (String declaredMapping : sr.getMappings()) {
                if (!mapping.equals(declaredMapping)) continue;
                return true;
            }
        }
        return false;
    }

    private String createMappingPath(ApplicationPath ap) {
        String path = ap.value();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/*")) {
            path = path.endsWith("/") ? path + "*" : path + "/*";
        }
        return path;
    }

    private Set<Class<? extends Application>> getApplicationClasses(Set<Class<?>> classes) {
        LinkedHashSet<Class<? extends Application>> s = new LinkedHashSet<Class<? extends Application>>();
        for (Class<?> c : classes) {
            if (Application.class == c || !Application.class.isAssignableFrom(c)) continue;
            s.add(c.asSubclass(Application.class));
        }
        return s;
    }

    private Set<Class<?>> getRootResourceAndProviderClasses(Set<Class<?>> classes) {
        LinkedHashSet s = new LinkedHashSet();
        for (Class<?> c : classes) {
            if (!c.isAnnotationPresent(Path.class) && !c.isAnnotationPresent(Provider.class)) continue;
            s.add(c);
        }
        return s;
    }
}

