/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.Collection;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.jersey.server.internal.monitoring.TimeReservoir;
import org.glassfish.jersey.server.internal.monitoring.UniformTimeSnapshot;

public class SlidingWindowTimeReservoir
implements TimeReservoir {
    private static final int COLLISION_BUFFER_POWER = 8;
    private static final int COLLISION_BUFFER = 256;
    private static final int TRIM_THRESHOLD = 256;
    private final ConcurrentNavigableMap<Long, Long> measurements = new ConcurrentSkipListMap<Long, Long>();
    private final long window;
    private final AtomicLong greatestTick;
    private final AtomicLong updateCount;
    private final long startTick;
    private final AtomicInteger trimOff;

    public SlidingWindowTimeReservoir(long window, TimeUnit windowUnit, long startTime, TimeUnit startTimeUnit) {
        this.window = windowUnit.toNanos(window) << 8;
        this.startTick = this.tick(startTime, startTimeUnit);
        this.greatestTick = new AtomicLong(this.startTick);
        this.updateCount = new AtomicLong(0L);
        this.trimOff = new AtomicInteger(0);
    }

    @Override
    public int size(long time, TimeUnit timeUnit) {
        this.conditionallyUpdateGreatestTick(this.tick(time, timeUnit));
        this.trim();
        return this.measurements.size();
    }

    @Override
    public void update(long value, long time, TimeUnit timeUnit) {
        if (this.updateCount.incrementAndGet() % 256L == 0L) {
            this.trim();
        }
        long tick = this.tick(time, timeUnit);
        if (this.greatestTick.get() - this.window > tick) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            if (this.measurements.putIfAbsent(tick, value) == null) {
                this.conditionallyUpdateGreatestTick(tick);
                break;
            }
            ++tick;
        }
    }

    private long conditionallyUpdateGreatestTick(long tick) {
        long currentGreatestTick;
        do {
            if (tick > (currentGreatestTick = this.greatestTick.get())) continue;
            return currentGreatestTick;
        } while (!this.greatestTick.compareAndSet(currentGreatestTick, tick));
        return tick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniformTimeSnapshot getSnapshot(long time, TimeUnit timeUnit) {
        this.trimOff.incrementAndGet();
        long baselineTick = this.conditionallyUpdateGreatestTick(this.tick(time, timeUnit));
        try {
            long measuredTickInterval = Math.min(baselineTick - this.startTick, this.window);
            Collection<Long> values = this.measurements.subMap((Object)(this.roundTick(baselineTick) - measuredTickInterval), true, (Object)baselineTick, true).values();
            UniformTimeSnapshot uniformTimeSnapshot = new UniformTimeSnapshot(values, measuredTickInterval >> 8, TimeUnit.NANOSECONDS);
            return uniformTimeSnapshot;
        }
        finally {
            this.trimOff.decrementAndGet();
            this.trim(baselineTick);
        }
    }

    private long tick(long time, TimeUnit timeUnit) {
        return timeUnit.toNanos(time) << 8;
    }

    private void trim() {
        this.trim(this.greatestTick.get());
    }

    private void trim(long baselineTick) {
        if (this.trimEnabled()) {
            this.measurements.headMap((Object)(this.roundTick(baselineTick) - this.window)).clear();
        }
    }

    private boolean trimEnabled() {
        return this.trimOff.get() == 0;
    }

    private long roundTick(long tick) {
        return tick >> 8 << 8;
    }
}

