/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.Collection;

class AggregatedValueObject {
    private final long max;
    private final long min;
    private final double mean;
    private final long count;

    public AggregatedValueObject(Collection<Long> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("The values collection must not be empty");
        }
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        long sum = 0L;
        for (Long value : values) {
            max = Math.max(max, value);
            min = Math.min(min, value);
            sum += value.longValue();
        }
        this.min = min;
        this.max = max;
        this.count = values.size();
        this.mean = (double)sum / (double)this.count;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public double getMean() {
        return this.mean;
    }

    public long getCount() {
        return this.count;
    }
}

