/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.PathSegment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class PathParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public PathParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator) {
        super(mpep, locator, Parameter.Source.PATH);
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        ParameterizedType pt;
        Type[] targs;
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        Class<?> rawParameterType = parameter.getRawType();
        if (rawParameterType == PathSegment.class) {
            return new PathParamPathSegmentValueFactory(parameterName, !parameter.isEncoded());
        }
        if (rawParameterType == List.class && parameter.getType() instanceof ParameterizedType && (targs = (pt = (ParameterizedType)parameter.getType()).getActualTypeArguments()).length == 1 && targs[0] == PathSegment.class) {
            return new PathParamListPathSegmentValueFactory(parameterName, !parameter.isEncoded());
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new PathParamValueFactory(e, !parameter.isEncoded());
    }

    private static final class PathParamListPathSegmentValueFactory
    extends AbstractContainerRequestValueFactory<List<PathSegment>> {
        private final String name;
        private final boolean decode;

        PathParamListPathSegmentValueFactory(String name, boolean decode) {
            this.name = name;
            this.decode = decode;
        }

        public List<PathSegment> provide() {
            return this.getContainerRequest().getUriInfo().getPathSegments(this.name, this.decode);
        }
    }

    private static final class PathParamPathSegmentValueFactory
    extends AbstractContainerRequestValueFactory<PathSegment> {
        private final String name;
        private final boolean decode;

        PathParamPathSegmentValueFactory(String name, boolean decode) {
            this.name = name;
            this.decode = decode;
        }

        public PathSegment provide() {
            List<PathSegment> ps = this.getContainerRequest().getUriInfo().getPathSegments(this.name, this.decode);
            if (ps.isEmpty()) {
                return null;
            }
            return ps.get(ps.size() - 1);
        }
    }

    private static final class PathParamValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final boolean decode;

        PathParamValueFactory(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        public Object provide() {
            try {
                return this.extractor.extract(this.getContainerRequest().getUriInfo().getPathParameters(this.decode));
            }
            catch (ExtractorException e) {
                throw new ParamException.PathParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<PathParam> {
        public InjectionResolver() {
            super(PathParamValueFactoryProvider.class);
        }
    }
}

