/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.HeaderParam;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class HeaderParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public HeaderParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator) {
        super(mpep, locator, Parameter.Source.HEADER);
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new HeaderParamValueFactory(e);
    }

    private static final class HeaderParamValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        HeaderParamValueFactory(MultivaluedParameterExtractor<?> extractor) {
            this.extractor = extractor;
        }

        public Object provide() {
            try {
                return this.extractor.extract(this.getContainerRequest().getHeaders());
            }
            catch (ExtractorException e) {
                throw new ParamException.HeaderParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<HeaderParam> {
        public InjectionResolver() {
            super(HeaderParamValueFactoryProvider.class);
        }
    }
}

