/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.ReaderInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.HttpHeadersInjectee;
import org.glassfish.jersey.internal.inject.RequestInjectee;
import org.glassfish.jersey.internal.inject.SecurityContextInjectee;
import org.glassfish.jersey.internal.inject.UriInfoInjectee;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;

class ReferencesInitializer
implements Function<ContainerRequest, ContainerRequest> {
    @Inject
    private ServiceLocator locator;
    @Inject
    private Provider<Ref<Request>> requestRefProvider;
    @Inject
    private Provider<Ref<ContainerRequest>> containerRequestRefProvider;
    @Inject
    private Provider<UriRoutingContext> uriRoutingCtxProvider;
    @Inject
    private UriInfoInjectee uriInfoInjectee;
    @Inject
    private HttpHeadersInjectee httpHeadersInjectee;
    @Inject
    private RequestInjectee requestInjectee;
    @Inject
    private SecurityContextInjectee securityContextInjectee;

    ReferencesInitializer() {
    }

    public ContainerRequest apply(ContainerRequest containerRequest) {
        ((Ref)this.requestRefProvider.get()).set(containerRequest.getRequest());
        ((Ref)this.containerRequestRefProvider.get()).set(containerRequest);
        RequestScopedInitializer requestScopedInitializer = containerRequest.getRequestScopedInitializer();
        if (requestScopedInitializer != null) {
            requestScopedInitializer.initialize(this.locator);
        }
        final UriRoutingContext uriRoutingCtx = (UriRoutingContext)this.uriRoutingCtxProvider.get();
        containerRequest.setUriRoutingContext(uriRoutingCtx);
        containerRequest.getRequestEventBuilder().setExtendedUriInfo(uriRoutingCtx);
        containerRequest.setReaderInterceptors(new Value<Iterable<ReaderInterceptor>>(){

            @Override
            public Iterable<ReaderInterceptor> get() {
                return uriRoutingCtx.getBoundReaderInterceptors();
            }
        });
        this.requestInjectee.set(containerRequest);
        this.uriInfoInjectee.set(uriRoutingCtx);
        this.httpHeadersInjectee.set(containerRequest);
        this.securityContextInjectee.setRequest(containerRequest);
        return containerRequest;
    }
}

