/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.RuntimeResourceModel;

public class ResourceModel
implements ResourceModelComponent {
    private final List<Resource> rootResources;
    private final List<Resource> resources;
    private final Value<RuntimeResourceModel> runtimeRootResourceModelValue;

    private ResourceModel(List<Resource> rootResources, List<Resource> allResources) {
        this.resources = allResources;
        this.rootResources = rootResources;
        this.runtimeRootResourceModelValue = Values.lazy(new Value<RuntimeResourceModel>(){

            @Override
            public RuntimeResourceModel get() {
                return new RuntimeResourceModel(ResourceModel.this.resources);
            }
        });
    }

    public List<Resource> getRootResources() {
        return this.rootResources;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    public void accept(ResourceModelVisitor visitor) {
        visitor.visitResourceModel(this);
    }

    @Override
    public List<? extends ResourceModelComponent> getComponents() {
        ArrayList components = Lists.newArrayList();
        components.addAll(this.resources);
        components.addAll(this.getRuntimeResourceModel().getRuntimeResources());
        return components;
    }

    public RuntimeResourceModel getRuntimeResourceModel() {
        return this.runtimeRootResourceModelValue.get();
    }

    public static class Builder {
        private final List<Resource> resources;
        private final boolean subResourceModel;

        public Builder(ResourceModel resourceModel, boolean subResourceModel) {
            this.resources = resourceModel.getResources();
            this.subResourceModel = subResourceModel;
        }

        public Builder(List<Resource> resources, boolean subResourceModel) {
            this.resources = resources;
            this.subResourceModel = subResourceModel;
        }

        public Builder(boolean subResourceModel) {
            this.resources = Lists.newArrayList();
            this.subResourceModel = subResourceModel;
        }

        public Builder addResource(Resource resource) {
            this.resources.add(resource);
            return this;
        }

        public ResourceModel build() {
            LinkedHashMap resourceMap = Maps.newLinkedHashMap();
            Set separateResources = Sets.newIdentityHashSet();
            for (Resource resource : this.resources) {
                String path = resource.getPath();
                if (path == null && !this.subResourceModel) {
                    separateResources.add(resource);
                    continue;
                }
                Resource fromMap = (Resource)resourceMap.get(path);
                if (fromMap == null) {
                    resourceMap.put(path, resource);
                    continue;
                }
                resourceMap.put(path, Resource.builder(fromMap).mergeWith(resource).build());
            }
            ArrayList rootResources = Lists.newArrayList();
            ArrayList allResources = Lists.newArrayList();
            for (Map.Entry entry : resourceMap.entrySet()) {
                if (entry.getKey() != null) {
                    rootResources.add(entry.getValue());
                }
                allResources.add(entry.getValue());
            }
            if (!this.subResourceModel) {
                allResources.addAll(separateResources);
            }
            return new ResourceModel(rootResources, allResources);
        }
    }
}

