/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.Severity;
import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.server.model.InvocableValidator;
import org.glassfish.jersey.server.model.ResourceMethodValidator;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelIssue;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.ResourceValidator;
import org.glassfish.jersey.server.model.RuntimeResourceModelValidator;
import org.glassfish.jersey.server.model.internal.ModelErrors;

public final class ComponentModelValidator {
    private final List<ResourceModelIssue> issueList = Lists.newLinkedList();
    private final List<ResourceModelVisitor> validators = Lists.newArrayList();

    public ComponentModelValidator(ServiceLocator locator) {
        this.validators.add(new ResourceValidator());
        this.validators.add(new RuntimeResourceModelValidator((MessageBodyWorkers)locator.getService(MessageBodyWorkers.class, new Annotation[0])));
        this.validators.add(new ResourceMethodValidator(locator));
        this.validators.add(new InvocableValidator());
    }

    public List<ResourceModelIssue> getIssueList() {
        return this.issueList;
    }

    public boolean fatalIssuesFound() {
        for (ResourceModelIssue issue : this.getIssueList()) {
            if (issue.getSeverity() != Severity.FATAL) continue;
            return true;
        }
        return false;
    }

    public void cleanIssueList() {
        this.issueList.clear();
    }

    public void validate(final ResourceModelComponent component) {
        Errors.process(new Runnable(){

            @Override
            public void run() {
                Errors.mark();
                ComponentModelValidator.this.validateWithErrors(component);
                ComponentModelValidator.this.issueList.addAll(ModelErrors.getErrorsAsResourceModelIssues(true));
                Errors.unmark();
            }
        });
    }

    private void validateWithErrors(ResourceModelComponent component) {
        for (ResourceModelVisitor validator : this.validators) {
            component.accept(validator);
        }
        List<? extends ResourceModelComponent> componentList = component.getComponents();
        if (null != componentList) {
            for (ResourceModelComponent resourceModelComponent : componentList) {
                this.validateWithErrors(resourceModelComponent);
            }
        }
    }
}

