/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import javax.inject.Provider;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ServerRuntime;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;

public class ChunkedOutput<T>
extends GenericType<T>
implements Closeable {
    private static final byte[] NO_DELIM = new byte[0];
    private final BlockingDeque<T> queue = new LinkedBlockingDeque<T>();
    private final byte[] chunkDelimiter;
    private volatile boolean closed = false;
    private boolean flushing = false;
    private volatile RequestScope requestScope;
    private volatile RequestScope.Instance requestScopeInstance;
    private volatile ContainerRequest requestContext;
    private volatile ContainerResponse responseContext;
    private volatile ServerRuntime.ConnectionCallbackRunner connectionCallbackRunner;
    private volatile Provider<AsyncContext> asyncContext;
    private volatile UriRoutingContext uriRoutingContext;

    protected ChunkedOutput() {
        this.chunkDelimiter = NO_DELIM;
    }

    public ChunkedOutput(Type chunkType) {
        super(chunkType);
        this.chunkDelimiter = NO_DELIM;
    }

    protected ChunkedOutput(byte[] chunkDelimiter) {
        if (chunkDelimiter.length > 0) {
            this.chunkDelimiter = new byte[chunkDelimiter.length];
            System.arraycopy(chunkDelimiter, 0, this.chunkDelimiter, 0, chunkDelimiter.length);
        } else {
            this.chunkDelimiter = NO_DELIM;
        }
    }

    public ChunkedOutput(Type chunkType, byte[] chunkDelimiter) {
        super(chunkType);
        if (chunkDelimiter.length > 0) {
            this.chunkDelimiter = new byte[chunkDelimiter.length];
            System.arraycopy(chunkDelimiter, 0, this.chunkDelimiter, 0, chunkDelimiter.length);
        } else {
            this.chunkDelimiter = NO_DELIM;
        }
    }

    protected ChunkedOutput(String chunkDelimiter) {
        this.chunkDelimiter = chunkDelimiter.isEmpty() ? NO_DELIM : chunkDelimiter.getBytes();
    }

    public ChunkedOutput(Type chunkType, String chunkDelimiter) {
        super(chunkType);
        this.chunkDelimiter = chunkDelimiter.isEmpty() ? NO_DELIM : chunkDelimiter.getBytes();
    }

    public void write(T chunk) throws IOException {
        if (this.closed) {
            throw new IOException(LocalizationMessages.CHUNKED_OUTPUT_CLOSED());
        }
        if (chunk != null) {
            this.queue.add(chunk);
        }
        this.flushQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void flushQueue() throws IOException {
        block18: {
            if (this.requestScopeInstance == null || this.requestContext == null || this.responseContext == null) {
                return;
            }
            Exception ex = null;
            this.requestScope.runInScope(this.requestScopeInstance, new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws IOException {
                    Object t;
                    boolean shouldClose;
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (ChunkedOutput.this.flushing) {
                            return null;
                        }
                        shouldClose = ChunkedOutput.this.closed;
                        t = ChunkedOutput.this.queue.poll();
                        if (t != null || shouldClose) {
                            ChunkedOutput.this.flushing = true;
                        }
                    }
                    while (t != null) {
                        try {
                            OutputStream origStream = ChunkedOutput.this.responseContext.getEntityStream();
                            OutputStream writtenStream = ChunkedOutput.this.requestContext.getWorkers().writeTo(t, t.getClass(), ChunkedOutput.this.getType(), ChunkedOutput.this.responseContext.getEntityAnnotations(), ChunkedOutput.this.responseContext.getMediaType(), ChunkedOutput.this.responseContext.getHeaders(), ChunkedOutput.this.requestContext.getPropertiesDelegate(), origStream, Collections.<WriterInterceptor>emptyList());
                            if (ChunkedOutput.this.chunkDelimiter != NO_DELIM) {
                                writtenStream.write(ChunkedOutput.this.chunkDelimiter);
                            }
                            writtenStream.flush();
                            if (origStream != writtenStream) {
                                ChunkedOutput.this.responseContext.setEntityStream(writtenStream);
                            }
                        }
                        catch (IOException ioe) {
                            ChunkedOutput.this.connectionCallbackRunner.onDisconnect((AsyncResponse)ChunkedOutput.this.asyncContext.get());
                            throw ioe;
                        }
                        catch (MappableException mpe) {
                            if (mpe.getCause() instanceof IOException) {
                                ChunkedOutput.this.connectionCallbackRunner.onDisconnect((AsyncResponse)ChunkedOutput.this.asyncContext.get());
                            }
                            throw mpe;
                        }
                        t = ChunkedOutput.this.queue.poll();
                        if (t != null) continue;
                        var1_1 = this;
                        synchronized (var1_1) {
                            shouldClose = ChunkedOutput.this.closed;
                            t = ChunkedOutput.this.queue.poll();
                            if (t == null) {
                                ChunkedOutput.this.responseContext.commitStream();
                                ChunkedOutput.this.flushing = shouldClose;
                                break;
                            }
                        }
                    }
                    return null;
                }
            });
            if (!this.closed) break block18;
            try {
                this.responseContext.close();
            }
            catch (Exception e) {
                ex = ex == null ? e : ex;
            }
            this.requestScopeInstance.release();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            break block18;
            catch (Exception e) {
                try {
                    this.closed = true;
                    ex = e;
                    if (!this.closed) break block18;
                }
                catch (Throwable throwable) {
                    if (this.closed) {
                        try {
                            this.responseContext.close();
                        }
                        catch (Exception e2) {
                            ex = ex == null ? e2 : ex;
                        }
                        this.requestScopeInstance.release();
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                    }
                    throw throwable;
                }
                try {
                    this.responseContext.close();
                }
                catch (Exception e3) {
                    ex = ex == null ? e3 : ex;
                }
                this.requestScopeInstance.release();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.flushQueue();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.queue.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ChunkedOutput<" + this.getType() + ">";
    }

    void setContext(RequestScope requestScope, RequestScope.Instance requestScopeInstance, ContainerRequest requestContext, ContainerResponse responseContext, ServerRuntime.ConnectionCallbackRunner connectionCallbackRunner, Provider<AsyncContext> asyncContext, UriRoutingContext uriRoutingContext) throws IOException {
        this.requestScope = requestScope;
        this.requestScopeInstance = requestScopeInstance;
        this.requestContext = requestContext;
        this.responseContext = responseContext;
        this.connectionCallbackRunner = connectionCallbackRunner;
        this.asyncContext = asyncContext;
        this.uriRoutingContext = uriRoutingContext;
        this.flushQueue();
    }
}

