/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.monitoring.MonitoringEventListener;
import org.glassfish.jersey.server.internal.monitoring.jmx.MBeanExposer;
import org.glassfish.jersey.server.monitoring.MonitoringStatistics;
import org.glassfish.jersey.server.monitoring.MonitoringStatisticsListener;

public class MonitoringFeature
implements Feature {
    private boolean monitoringEnabled = true;
    private boolean mBeansEnabled;
    private static final Logger LOGGER = Logger.getLogger(MonitoringFeature.class.getName());

    @Override
    public boolean configure(FeatureContext context) {
        Boolean monitoringEnabledProperty = ServerProperties.getValue(context.getConfiguration().getProperties(), "jersey.config.server.monitoring.statistics.enabled", null, Boolean.class);
        Boolean mbeansEnabledProperty = ServerProperties.getValue(context.getConfiguration().getProperties(), "jersey.config.server.monitoring.statistics.mbeans.enabled", null, Boolean.class);
        if (monitoringEnabledProperty != null) {
            this.monitoringEnabled = monitoringEnabledProperty;
        }
        if (mbeansEnabledProperty != null) {
            this.monitoringEnabled = this.monitoringEnabled || mbeansEnabledProperty != false;
            this.mBeansEnabled = mbeansEnabledProperty;
        }
        if (monitoringEnabledProperty != null && !monitoringEnabledProperty.booleanValue()) {
            if (mbeansEnabledProperty != null && this.mBeansEnabled) {
                LOGGER.log(Level.WARNING, LocalizationMessages.WARNING_MONITORING_FEATURE_ENABLED("jersey.config.server.monitoring.statistics.enabled"));
            } else {
                LOGGER.log(Level.WARNING, LocalizationMessages.WARNING_MONITORING_FEATURE_ENABLED("jersey.config.server.monitoring.statistics.enabled"));
            }
        }
        if (this.monitoringEnabled) {
            context.register(MonitoringEventListener.class);
            context.register(new AbstractBinder(){

                protected void configure() {
                    this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<MonitoringStatistics>>(){}).in(Singleton.class);
                    this.bindFactory(StatisticsInjectionFactory.class).to(MonitoringStatistics.class).in(PerLookup.class);
                    this.bind(StatisticsListener.class).to(MonitoringStatisticsListener.class).in(Singleton.class);
                }
            });
        }
        if (this.mBeansEnabled) {
            context.register(new MBeanExposer());
        }
        return this.monitoringEnabled;
    }

    public void setmBeansEnabled(boolean mBeansEnabled) {
        this.mBeansEnabled = mBeansEnabled;
    }

    private static class StatisticsListener
    implements MonitoringStatisticsListener {
        @Inject
        Provider<Ref<MonitoringStatistics>> statisticsFactory;

        private StatisticsListener() {
        }

        @Override
        public void onStatistics(MonitoringStatistics statistics) {
            ((Ref)this.statisticsFactory.get()).set(statistics);
        }
    }

    private static class StatisticsInjectionFactory
    extends ReferencingFactory<MonitoringStatistics> {
        @Inject
        public StatisticsInjectionFactory(Provider<Ref<MonitoringStatistics>> referenceFactory) {
            super(referenceFactory);
        }

        @Override
        public MonitoringStatistics provide() {
            return (MonitoringStatistics)super.provide();
        }

        @Override
        public void dispose(MonitoringStatistics monitoringStatistics) {
        }
    }
}

