/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.servlet.Servlet;
import javax.ws.rs.core.PathSegment;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.uri.UriComponent;

public final class GrizzlyWebContainerFactory {
    private GrizzlyWebContainerFactory() {
    }

    public static HttpServer create(String u) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyWebContainerFactory.create(URI.create(u));
    }

    public static HttpServer create(String u, Map<String, String> initParams) throws IOException, IllegalArgumentException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyWebContainerFactory.create(URI.create(u), initParams);
    }

    public static HttpServer create(URI u) throws IOException, IllegalArgumentException {
        return GrizzlyWebContainerFactory.create(u, ServletContainer.class);
    }

    public static HttpServer create(URI u, Map<String, String> initParams) throws IOException {
        return GrizzlyWebContainerFactory.create(u, ServletContainer.class, initParams);
    }

    public static HttpServer create(String u, Class<? extends Servlet> c) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyWebContainerFactory.create(URI.create(u), c);
    }

    public static HttpServer create(String u, Class<? extends Servlet> c, Map<String, String> initParams) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyWebContainerFactory.create(URI.create(u), c, initParams);
    }

    public static HttpServer create(URI u, Class<? extends Servlet> c) throws IOException {
        return GrizzlyWebContainerFactory.create(u, c, null);
    }

    public static HttpServer create(URI u, Class<? extends Servlet> c, Map<String, String> initParams) throws IOException {
        return GrizzlyWebContainerFactory.create(u, c, null, initParams, null);
    }

    private static HttpServer create(URI u, Class<? extends Servlet> c, Servlet servlet, Map<String, String> initParams, Map<String, String> contextInitParams) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String path = u.getPath();
        if (path == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ", must be non-null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ", must be present");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ". must start with a '/'");
        }
        path = String.format("/%s", ((PathSegment)UriComponent.decodePath((String)u.getPath(), (boolean)true).get(1)).toString());
        WebappContext context = new WebappContext("GrizzlyContext", path);
        ServletRegistration registration = c != null ? context.addServlet(c.getName(), c) : context.addServlet(servlet.getClass().getName(), servlet);
        registration.addMapping(new String[]{"/*"});
        if (contextInitParams != null) {
            for (Map.Entry<String, String> e : contextInitParams.entrySet()) {
                context.setInitParameter(e.getKey(), e.getValue());
            }
        }
        ResourceConfig configuration = new ResourceConfig();
        if (initParams != null) {
            registration.setInitParameters(initParams);
            configuration.addProperties(initParams);
        }
        HttpServer server = GrizzlyHttpServerFactory.createHttpServer((URI)u, (ResourceConfig)configuration);
        context.deploy(server);
        return server;
    }

    public static HttpServer create(URI u, Servlet servlet, Map<String, String> initParams, Map<String, String> contextInitParams) throws IOException {
        if (servlet == null) {
            throw new IllegalArgumentException("The servlet must not be null");
        }
        return GrizzlyWebContainerFactory.create(u, null, servlet, initParams, contextInitParams);
    }
}

