/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JettyHttpContainer
extends Handler.Abstract
implements Container {
    private static final ExtendedLogger LOGGER = new ExtendedLogger(Logger.getLogger(JettyHttpContainer.class.getName()), Level.FINEST);
    private static final Type REQUEST_TYPE = new GenericType<Ref<Request>>(){}.getType();
    private static final Type RESPONSE_TYPE = new GenericType<Ref<Response>>(){}.getType();
    private static final int INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    private static final Response.Status BAD_REQUEST_STATUS = Response.Status.BAD_REQUEST;
    private boolean configSetStatusOverSendError;
    private volatile ApplicationHandler appHandler;

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        ResponseWriter responseWriter = new ResponseWriter(request, response, callback, this.configSetStatusOverSendError);
        try {
            URI baseUri = this.getBaseUri(request);
            URI requestUri = this.getRequestUri(request, baseUri);
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod(), this.getSecurityContext(request), (PropertiesDelegate)new MapPropertiesDelegate(), (Configuration)this.appHandler.getConfiguration());
            requestContext.setEntityStream(Request.asInputStream((Request)request));
            request.getHeaders().forEach(httpField -> requestContext.headers(httpField.getName(), new Object[]{httpField.getValue() == null ? "" : httpField.getValue()}));
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            requestContext.setRequestScopedInitializer(injectionManager -> {
                ((Ref)injectionManager.getInstance(REQUEST_TYPE)).set((Object)request);
                ((Ref)injectionManager.getInstance(RESPONSE_TYPE)).set((Object)response);
            });
            this.appHandler.handle(requestContext);
            return true;
        }
        catch (URISyntaxException e) {
            this.setResponseForInvalidUri(request, response, callback, e);
            return true;
        }
        catch (Exception ex) {
            callback.failed((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private URI getRequestUri(Request request, URI baseUri) throws URISyntaxException {
        String serverAddress = this.getServerAddress(baseUri);
        String uri = request.getHttpURI().getPath();
        String queryString = request.getHttpURI().getQuery();
        if (queryString != null) {
            uri = uri + "?" + ContainerUtils.encodeUnsafeCharacters((String)queryString);
        }
        return new URI(serverAddress + uri);
    }

    private void setResponseForInvalidUri(Request request, Response response, Callback callback, Throwable throwable) {
        LOGGER.log(Level.FINER, "Error while processing request.", throwable);
        if (this.configSetStatusOverSendError) {
            response.reset();
            response.setStatus(BAD_REQUEST_STATUS.getStatusCode());
            callback.failed(throwable);
        } else {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)BAD_REQUEST_STATUS.getStatusCode(), (String)BAD_REQUEST_STATUS.getReasonPhrase(), (Throwable)throwable);
        }
    }

    private String getServerAddress(URI baseUri) {
        String serverAddress = baseUri.toString();
        if (serverAddress.charAt(serverAddress.length() - 1) == '/') {
            return serverAddress.substring(0, serverAddress.length() - 1);
        }
        return serverAddress;
    }

    private SecurityContext getSecurityContext(final Request request) {
        final AuthenticationState.Succeeded authenticationState = AuthenticationState.authenticate((Request)request);
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return authenticationState != null && authenticationState.isUserInRole(role);
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public Principal getUserPrincipal() {
                return authenticationState != null ? authenticationState.getUserIdentity().getUserPrincipal() : null;
            }

            public String getAuthenticationScheme() {
                return authenticationState != null ? authenticationState.getAuthenticationType() : null;
            }
        };
    }

    private URI getBaseUri(Request request) throws URISyntaxException {
        return new URI(request.getHttpURI().getScheme(), null, Request.getServerName((Request)request), Request.getServerPort((Request)request), this.getBasePath(request), null, null);
    }

    private String getBasePath(Request request) {
        String contextPath = Request.getContextPath((Request)request);
        if (contextPath == null || contextPath.isEmpty()) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(new ResourceConfig(this.getConfiguration()));
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown((Container)this);
        this.appHandler = new ApplicationHandler((Application)configuration.register((Object)new JettyBinder()));
        this.appHandler.onReload((Container)this);
        this.appHandler.onStartup((Container)this);
        this.cacheConfigSetStatusOverSendError();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.appHandler.onStartup((Container)this);
    }

    public void doStop() throws Exception {
        super.doStop();
        this.appHandler.onShutdown((Container)this);
        this.appHandler = null;
    }

    JettyHttpContainer(Application application, Object parentContext) {
        this.appHandler = new ApplicationHandler(application, (Binder)new JettyBinder(), parentContext);
    }

    JettyHttpContainer(Application application) {
        this.appHandler = new ApplicationHandler(application, (Binder)new JettyBinder());
        this.cacheConfigSetStatusOverSendError();
    }

    JettyHttpContainer(Class<? extends Application> applicationClass) {
        this.appHandler = new ApplicationHandler(applicationClass, (Binder)new JettyBinder());
        this.cacheConfigSetStatusOverSendError();
    }

    private void cacheConfigSetStatusOverSendError() {
        this.configSetStatusOverSendError = (Boolean)ServerProperties.getValue((Map)this.getConfiguration().getProperties(), (String)"jersey.config.server.response.setStatusOverSendError", (Object)false, Boolean.class);
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final Request request;
        private final Response response;
        private final Callback callback;
        private final boolean configSetStatusOverSendError;
        private final Timer timer = new Timer();
        private final long asyncStartTimeMillis;
        private final ConcurrentLinkedQueue<ContainerResponseWriter.TimeoutHandler> timeoutHandlerQueue = new ConcurrentLinkedQueue();
        private TimerTask currentTimerTask;

        ResponseWriter(Request request, Response response, Callback callback, boolean configSetStatusOverSendError) {
            this.request = request;
            this.response = response;
            this.callback = callback;
            this.asyncStartTimeMillis = System.currentTimeMillis();
            this.configSetStatusOverSendError = configSetStatusOverSendError;
        }

        private synchronized void setNewTimeout(long timeOut, TimeUnit timeUnit) {
            long timeOutMillis = timeUnit.toMillis(timeOut);
            if (this.currentTimerTask != null) {
                this.currentTimerTask.cancel();
            }
            this.currentTimerTask = new TimerTask(){

                @Override
                public void run() {
                    timeoutHandlerQueue.forEach(timeoutHandler -> timeoutHandler.onTimeout((ContainerResponseWriter)this));
                }
            };
            this.timer.schedule(this.currentTimerTask, Math.max(0L, timeOutMillis + this.asyncStartTimeMillis - System.currentTimeMillis()));
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            Response.StatusType statusInfo = context.getStatusInfo();
            int code = statusInfo.getStatusCode();
            this.response.setStatus(code);
            if (contentLength != -1L && contentLength < Integer.MAX_VALUE && !"HEAD".equals(this.request.getMethod())) {
                this.response.getHeaders().add(new HttpField(HttpHeader.CONTENT_LENGTH, String.valueOf((int)contentLength)));
            }
            for (Map.Entry e : context.getStringHeaders().entrySet()) {
                for (String value : (List)e.getValue()) {
                    this.response.getHeaders().add(new HttpField((String)e.getKey(), value));
                }
            }
            return Content.Sink.asOutputStream((Content.Sink)this.response);
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            if (timeOut > 0L) {
                this.setNewTimeout(timeOut, timeUnit);
            }
            if (timeoutHandler != null) {
                this.timeoutHandlerQueue.add(timeoutHandler);
            }
            return true;
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            if (timeOut > 0L) {
                this.setNewTimeout(timeOut, timeUnit);
            }
        }

        public void commit() {
            this.callback.succeeded();
            LOGGER.log(Level.FINEST, "commit() called");
        }

        public void failure(Throwable error) {
            block6: {
                try {
                    if (this.response.isCommitted()) break block6;
                    try {
                        if (this.configSetStatusOverSendError) {
                            this.response.reset();
                            this.response.setStatus(INTERNAL_SERVER_ERROR);
                            this.callback.failed(error);
                            break block6;
                        }
                        Response.writeError((Request)this.request, (Response)this.response, (Callback)this.callback, (int)INTERNAL_SERVER_ERROR, (String)"Request failed.", (Throwable)error);
                    }
                    catch (IllegalStateException ex) {
                        LOGGER.log(Level.FINER, "Unable to reset failed response.", (Throwable)ex);
                    }
                }
                finally {
                    LOGGER.log(Level.FINEST, "failure(...) called");
                    this.rethrow(error);
                }
            }
        }

        public boolean enableResponseBuffering() {
            return false;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }
    }

    private static class JettyBinder
    extends AbstractBinder {
        private JettyBinder() {
        }

        protected void configure() {
            ((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(JettyRequestReferencingFactory.class).to(Request.class)).proxy(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<Request>>(){})).in(RequestScoped.class);
            ((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(JettyResponseReferencingFactory.class).to(Response.class)).proxy(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<Response>>(){})).in(RequestScoped.class);
        }
    }

    private static class JettyResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public JettyResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class JettyRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public JettyRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

