/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainerProvider;
import org.glassfish.jersey.server.JerseySeBootstrapConfiguration;
import org.glassfish.jersey.server.spi.WebServer;

final class NettyHttpServer
implements WebServer {
    private final NettyHttpContainer container;
    private final ServerBootstrap serverBootstrap;
    private volatile Channel channel;
    private final int port;

    NettyHttpServer(Application application, JerseySeBootstrapConfiguration configuration) {
        this(new NettyHttpContainer(application), configuration);
    }

    NettyHttpServer(Class<? extends Application> applicationClass, JerseySeBootstrapConfiguration configuration) {
        this(new NettyHttpContainer(applicationClass), configuration);
    }

    NettyHttpServer(NettyHttpContainer container, JerseySeBootstrapConfiguration configuration) {
        SSLContext sslContext = configuration.sslContext();
        SeBootstrap.Configuration.SSLClientAuthentication sslClientAuthentication = configuration.sslClientAuthentication();
        URI uri = configuration.uri(true);
        this.port = NettyHttpContainerProvider.getPort(uri);
        this.container = container;
        this.serverBootstrap = NettyHttpContainerProvider.createServerBootstrap(uri, this.container, (SslContext)(configuration.isHttps() ? new JdkSslContext(sslContext, false, NettyHttpServer.nettyClientAuth(sslClientAuthentication)) : null));
        if (configuration.autoStart()) {
            this.channel = NettyHttpContainerProvider.startServer(this.port, this.container, this.serverBootstrap, false);
        }
    }

    private static final ClientAuth nettyClientAuth(SeBootstrap.Configuration.SSLClientAuthentication sslClientAuthentication) {
        switch (sslClientAuthentication) {
            case MANDATORY: {
                return ClientAuth.REQUIRE;
            }
            case OPTIONAL: {
                return ClientAuth.OPTIONAL;
            }
        }
        return ClientAuth.NONE;
    }

    public final NettyHttpContainer container() {
        return this.container;
    }

    public final int port() {
        return this.channel == null ? this.port : ((InetSocketAddress)this.channel.localAddress()).getPort();
    }

    public final CompletableFuture<Object> start() {
        return this.channel != null ? CompletableFuture.completedFuture(this.channel) : CompletableFuture.supplyAsync(() -> {
            try {
                this.channel = NettyHttpContainerProvider.startServer(this.port, this.container, this.serverBootstrap, false);
                return this.channel;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public final CompletableFuture<Void> stop() {
        return this.channel == null ? CompletableFuture.completedFuture(null) : CompletableFuture.supplyAsync(() -> {
            try {
                return (Void)this.channel.close().get();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public final <T> T unwrap(Class<T> nativeClass) {
        return nativeClass.cast(this.channel == null ? this.serverBootstrap : this.channel);
    }
}

