/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.simple;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.internal.util.collection.UnsafeValue;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.simple.SimpleContainer;
import org.glassfish.jersey.simple.SimpleServer;
import org.glassfish.jersey.simple.SimpleTraceAnalyzer;
import org.glassfish.jersey.simple.internal.LocalizationMessages;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerSocketProcessor;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.simpleframework.transport.trace.TraceAnalyzer;

public final class SimpleContainerFactory {
    private SimpleContainerFactory() {
    }

    public static SimpleServer create(URI address, ResourceConfig config) {
        return SimpleContainerFactory.create(address, null, new SimpleContainer((Application)config));
    }

    public static SimpleServer create(URI address, ResourceConfig config, int count, int select) {
        return SimpleContainerFactory.create(address, null, new SimpleContainer((Application)config), count, select);
    }

    public static SimpleServer create(URI address, SSLContext context, ResourceConfig config) {
        return SimpleContainerFactory.create(address, context, new SimpleContainer((Application)config));
    }

    public static SimpleServer create(URI address, SSLContext context, ResourceConfig config, int count, int select) {
        return SimpleContainerFactory.create(address, context, new SimpleContainer((Application)config), count, select);
    }

    public static SimpleServer create(URI address, SSLContext context, final SimpleContainer container) {
        return SimpleContainerFactory._create(address, context, container, new UnsafeValue<SocketProcessor, IOException>(){

            public SocketProcessor get() throws IOException {
                return new ContainerSocketProcessor((Container)container);
            }
        });
    }

    public static SimpleServer create(URI address, SSLContext context, ResourceConfig config, Object parentContext, int count, int select) {
        return SimpleContainerFactory.create(address, context, new SimpleContainer((Application)config, parentContext), count, select);
    }

    public static SimpleServer create(URI address, SSLContext context, final SimpleContainer container, final int count, final int select) throws ProcessingException {
        return SimpleContainerFactory._create(address, context, container, new UnsafeValue<SocketProcessor, IOException>(){

            public SocketProcessor get() throws IOException {
                return new ContainerSocketProcessor((Container)container, count, select);
            }
        });
    }

    private static SimpleServer _create(URI address, SSLContext context, final SimpleContainer container, UnsafeValue<SocketProcessor, IOException> serverProvider) throws ProcessingException {
        int port;
        if (address == null) {
            throw new IllegalArgumentException(LocalizationMessages.URI_CANNOT_BE_NULL());
        }
        String scheme = address.getScheme();
        int defaultPort = 80;
        if (context == null) {
            if (!scheme.equalsIgnoreCase("http")) {
                throw new IllegalArgumentException(LocalizationMessages.WRONG_SCHEME_WHEN_USING_HTTP());
            }
        } else {
            if (!scheme.equalsIgnoreCase("https")) {
                throw new IllegalArgumentException(LocalizationMessages.WRONG_SCHEME_WHEN_USING_HTTPS());
            }
            defaultPort = 443;
        }
        if ((port = address.getPort()) == -1) {
            port = defaultPort;
        }
        InetSocketAddress listen = new InetSocketAddress(port);
        try {
            final SimpleTraceAnalyzer analyzer = new SimpleTraceAnalyzer();
            SocketProcessor server = (SocketProcessor)serverProvider.get();
            SocketConnection connection = new SocketConnection(server, (TraceAnalyzer)analyzer);
            SocketAddress socketAddr = connection.connect((SocketAddress)listen, context);
            container.onServerStart();
            return new SimpleServer((Connection)connection, socketAddr){
                final /* synthetic */ Connection val$connection;
                final /* synthetic */ SocketAddress val$socketAddr;
                {
                    this.val$connection = connection;
                    this.val$socketAddr = socketAddress;
                }

                @Override
                public void close() throws IOException {
                    container.onServerStop();
                    analyzer.stop();
                    this.val$connection.close();
                }

                @Override
                public int getPort() {
                    return ((InetSocketAddress)this.val$socketAddr).getPort();
                }

                @Override
                public boolean isDebug() {
                    return analyzer.isActive();
                }

                @Override
                public void setDebug(boolean enable) {
                    if (enable) {
                        analyzer.start();
                    } else {
                        analyzer.stop();
                    }
                }
            };
        }
        catch (IOException ex) {
            throw new ProcessingException(LocalizationMessages.ERROR_WHEN_CREATING_SERVER(), (Throwable)ex);
        }
    }
}

