
package org.glassfish.jersey.simple.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.simple.internal.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableWRONG_SCHEME_WHEN_USING_HTTP() {
        return MESSAGE_FACTORY.getMessage("wrong.scheme.when.using.http");
    }

    /**
     * The URI scheme should be 'http' when not using SSL.
     * 
     */
    public static String WRONG_SCHEME_WHEN_USING_HTTP() {
        return LOCALIZER.localize(localizableWRONG_SCHEME_WHEN_USING_HTTP());
    }

    public static Localizable localizableWRONG_SCHEME_WHEN_USING_HTTPS() {
        return MESSAGE_FACTORY.getMessage("wrong.scheme.when.using.https");
    }

    /**
     * The URI scheme should be 'https' when using SSL.
     * 
     */
    public static String WRONG_SCHEME_WHEN_USING_HTTPS() {
        return LOCALIZER.localize(localizableWRONG_SCHEME_WHEN_USING_HTTPS());
    }

    public static Localizable localizableURI_CANNOT_BE_NULL() {
        return MESSAGE_FACTORY.getMessage("uri.cannot.be.null");
    }

    /**
     * The URI must not be null.
     * 
     */
    public static String URI_CANNOT_BE_NULL() {
        return LOCALIZER.localize(localizableURI_CANNOT_BE_NULL());
    }

    public static Localizable localizableERROR_WHEN_CREATING_SERVER() {
        return MESSAGE_FACTORY.getMessage("error.when.creating.server");
    }

    /**
     * IOException thrown when trying to create simple server.
     * 
     */
    public static String ERROR_WHEN_CREATING_SERVER() {
        return LOCALIZER.localize(localizableERROR_WHEN_CREATING_SERVER());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
