/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.jersey.linking.ELLinkBuilder;
import org.glassfish.jersey.linking.EntityDescriptor;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.LinkHeaderDescriptor;
import org.glassfish.jersey.linking.mapping.ResourceMappingContext;

class HeaderProcessor<T> {
    private EntityDescriptor instanceDescriptor;

    HeaderProcessor(Class<T> c) {
        this.instanceDescriptor = EntityDescriptor.getInstance(c);
    }

    void processLinkHeaders(T entity, UriInfo uriInfo, ResourceMappingContext rmc, MultivaluedMap<String, Object> headers) {
        List<String> headerValues = this.getLinkHeaderValues(entity, uriInfo, rmc);
        for (String headerValue : headerValues) {
            headers.add((Object)"Link", (Object)headerValue);
        }
    }

    List<String> getLinkHeaderValues(Object entity, UriInfo uriInfo, ResourceMappingContext rmc) {
        List matchedResources = uriInfo.getMatchedResources();
        if (!matchedResources.isEmpty()) {
            Object resource = matchedResources.get(0);
            ArrayList<String> headerValues = new ArrayList<String>();
            for (LinkHeaderDescriptor desc : this.instanceDescriptor.getLinkHeaders()) {
                if (!ELLinkBuilder.evaluateCondition(desc.getCondition(), entity, resource, entity)) continue;
                String headerValue = HeaderProcessor.getLinkHeaderValue(desc, entity, resource, uriInfo, rmc);
                headerValues.add(headerValue);
            }
            return headerValues;
        }
        return Collections.emptyList();
    }

    private static String getLinkHeaderValue(LinkHeaderDescriptor desc, Object entity, Object resource, UriInfo uriInfo, ResourceMappingContext rmc) {
        URI uri = ELLinkBuilder.buildURI(desc, entity, resource, entity, uriInfo, rmc);
        InjectLink link = desc.getLinkHeader();
        return InjectLink.Util.buildLinkFromUri(uri, link).toString();
    }
}

