
package org.glassfish.jersey.server.mvc.jsp.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.server.mvc.jsp.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableNO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(Object arg0) {
        return messageFactory.getMessage("no.request.dispatcher.for.resolved.path", arg0);
    }

    /**
     * No request dispatcher for: {0}
     * 
     */
    public static String NO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(Object arg0) {
        return localizer.localize(localizableNO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(arg0));
    }

    public static Localizable localizableRESOURCE_PATH_NOT_IN_CORRECT_FORM(Object arg0) {
        return messageFactory.getMessage("resource.path.not.in.correct.form", arg0);
    }

    /**
     * Resource path "{0}" is not in correct form.
     * 
     */
    public static String RESOURCE_PATH_NOT_IN_CORRECT_FORM(Object arg0) {
        return localizer.localize(localizableRESOURCE_PATH_NOT_IN_CORRECT_FORM(arg0));
    }

    public static Localizable localizableUNABLE_TO_FIND_PAGE_FOR_RESOLVING_CLASS(Object arg0, Object arg1) {
        return messageFactory.getMessage("unable.to.find.page.for.resolving.class", arg0, arg1);
    }

    /**
     * Unable to find "{0}" for {1}.
     * 
     */
    public static String UNABLE_TO_FIND_PAGE_FOR_RESOLVING_CLASS(Object arg0, Object arg1) {
        return localizer.localize(localizableUNABLE_TO_FIND_PAGE_FOR_RESOLVING_CLASS(arg0, arg1));
    }

}
