
package org.glassfish.jersey.server.mvc.jsp.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.server.mvc.jsp.internal.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableUNABLE_TO_FIND_PAGE_FOR_RESOLVING_CLASS(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("unable.to.find.page.for.resolving.class", arg0, arg1);
    }

    /**
     * Unable to find "{0}" for {1}.
     * 
     */
    public static String UNABLE_TO_FIND_PAGE_FOR_RESOLVING_CLASS(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableUNABLE_TO_FIND_PAGE_FOR_RESOLVING_CLASS(arg0, arg1));
    }

    public static Localizable localizableERROR_VIEWABLE_INCORRECT_INSTANCE() {
        return MESSAGE_FACTORY.getMessage("error.viewable.incorrect.instance");
    }

    /**
     * viewable argument must be an instance of ResolvedViewable.
     * 
     */
    public static String ERROR_VIEWABLE_INCORRECT_INSTANCE() {
        return LOCALIZER.localize(localizableERROR_VIEWABLE_INCORRECT_INSTANCE());
    }

    public static Localizable localizableNO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(Object arg0) {
        return MESSAGE_FACTORY.getMessage("no.request.dispatcher.for.resolved.path", arg0);
    }

    /**
     * No request dispatcher for: {0}
     * 
     */
    public static String NO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(Object arg0) {
        return LOCALIZER.localize(localizableNO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(arg0));
    }

    public static Localizable localizableRESOURCE_PATH_NOT_IN_CORRECT_FORM(Object arg0) {
        return MESSAGE_FACTORY.getMessage("resource.path.not.in.correct.form", arg0);
    }

    /**
     * Resource path "{0}" is not in correct form.
     * 
     */
    public static String RESOURCE_PATH_NOT_IN_CORRECT_FORM(Object arg0) {
        return LOCALIZER.localize(localizableRESOURCE_PATH_NOT_IN_CORRECT_FORM(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
