/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.jersey.microprofile.restclient.RestClientModel;

class ProxyInvocationHandler
implements InvocationHandler {
    private final Client client;
    private final WebTarget target;
    private final RestClientModel restClientModel;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    ProxyInvocationHandler(Client client, WebTarget target, RestClientModel restClientModel) {
        this.client = client;
        this.target = target;
        this.restClientModel = restClientModel;
    }

    ProxyInvocationHandler(WebTarget target, RestClientModel restClientModel) {
        this(null, target, restClientModel);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("toString") && (args == null || args.length == 0)) {
            return this.restClientModel.toString();
        }
        if (method.getName().equals("close") && (args == null || args.length == 0)) {
            this.closed.set(true);
            if (null != this.client) {
                this.client.close();
            }
            return null;
        }
        if (this.closed.get()) {
            throw new IllegalStateException("Attempting to invoke a method on a closed client.");
        }
        return this.restClientModel.invokeMethod(this.target, method, args);
    }
}

