
package org.glassfish.jersey.jsonb;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.jsonb.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableERROR_JSONB_DESERIALIZATION() {
        return MESSAGE_FACTORY.getMessage("error.jsonb.deserialization");
    }

    /**
     * Error deserializing object from entity stream.
     * 
     */
    public static String ERROR_JSONB_DESERIALIZATION() {
        return LOCALIZER.localize(localizableERROR_JSONB_DESERIALIZATION());
    }

    public static Localizable localizableERROR_JSONB_SERIALIZATION() {
        return MESSAGE_FACTORY.getMessage("error.jsonb.serialization");
    }

    /**
     * Error writing JSON-B serialized object.
     * 
     */
    public static String ERROR_JSONB_SERIALIZATION() {
        return LOCALIZER.localize(localizableERROR_JSONB_SERIALIZATION());
    }

    public static Localizable localizableERROR_JSONB_EMPTYSTREAM() {
        return MESSAGE_FACTORY.getMessage("error.jsonb.emptystream");
    }

    /**
     * JSON-B cannot parse empty input stream.
     * 
     */
    public static String ERROR_JSONB_EMPTYSTREAM() {
        return LOCALIZER.localize(localizableERROR_JSONB_EMPTYSTREAM());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
