
package org.glassfish.jersey.jackson;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.jackson.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableERROR_JACKSON_STREAMREADCONSTRAINTS(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.jackson.streamreadconstraints", arg0);
    }

    /**
     * Error setting StreamReadConstraints: {0}. Possibly not Jackson 2.15?
     * 
     */
    public static String ERROR_JACKSON_STREAMREADCONSTRAINTS(Object arg0) {
        return LOCALIZER.localize(localizableERROR_JACKSON_STREAMREADCONSTRAINTS(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
