/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.json.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.jaxb.ObjectGraph;
import org.glassfish.jersey.message.filtering.spi.ObjectProvider;
import org.glassfish.jersey.moxy.json.internal.ConfigurableMoxyJsonProvider;

@Singleton
public class FilteringMoxyJsonProvider
extends ConfigurableMoxyJsonProvider {
    @Inject
    private Provider<ObjectProvider<ObjectGraph>> provider;

    @Override
    protected void preWriteTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, Marshaller marshaller) throws JAXBException {
        Object objectGraph;
        super.preWriteTo(object, type, genericType, annotations, mediaType, httpHeaders, marshaller);
        if (marshaller.getProperty("eclipselink.object-graph") == null && (objectGraph = ((ObjectProvider)this.provider.get()).getFilteringObject(genericType, true, annotations)) != null) {
            marshaller.setProperty("eclipselink.object-graph", objectGraph);
        }
    }

    @Override
    protected void preReadFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, Unmarshaller unmarshaller) throws JAXBException {
        Object objectGraph;
        super.preReadFrom(type, genericType, annotations, mediaType, httpHeaders, unmarshaller);
        if (unmarshaller.getProperty("eclipselink.object-graph") == null && (objectGraph = ((ObjectProvider)this.provider.get()).getFilteringObject(genericType, false, annotations)) != null) {
            unmarshaller.setProperty("eclipselink.object-graph", objectGraph);
        }
    }
}

